/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib.texttest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xtend.util.stdlib.texttest.Failed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handle {
    private String filename;
    private List<String> lines;
    private String contentsAsString;

    public Handle(String filename) {
        this.filename = filename;
    }

    public String toString() {
        return this.filename;
    }

    public void sameContentAs(Handle compareFile) {
        List<String> lines1 = this.getContents();
        List<String> lines2 = compareFile.getContents();
        int count = lines1.size() < lines2.size() ? lines1.size() : lines2.size();
        int i = 0;
        while (i < count) {
            String s2;
            String s1 = lines1.get(i);
            if (!s1.equals(s2 = lines2.get(i))) {
                throw new Failed(String.valueOf(this.filename) + " does not have the same contents as " + compareFile.filename + ". First difference in line " + i + ": should be: '" + s2 + "', but is '" + s1 + "'");
            }
            ++i;
        }
    }

    public List<String> getContents() {
        if (this.lines == null) {
            try {
                this.lines = this.loadContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.lines;
    }

    private List<String> loadContent() throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getFileIS(this.filename)));
        while (br.ready()) {
            l.add(br.readLine());
        }
        br.close();
        return l;
    }

    public void contains(String substring) {
        if (this.getContentsAsString().indexOf(substring) < 0) {
            throw new Failed(String.valueOf(this.filename) + " does not contain '" + substring + "'");
        }
    }

    public int lineOf(String substring) {
        int i = 0;
        while (i < this.getContents().size()) {
            String line = this.getContents().get(i);
            if (line.indexOf(substring) >= 0) {
                return i;
            }
            ++i;
        }
        throw new Failed("the substring '" + substring + "' can't be found in the content of " + this.filename);
    }

    private String getContentsAsString() {
        if (this.contentsAsString == null) {
            StringBuffer bf = new StringBuffer();
            for (String s : this.getContents()) {
                bf.append(String.valueOf(s) + "\n");
            }
            this.contentsAsString = bf.toString();
        }
        return this.contentsAsString;
    }

    public void removeBlankLines() {
        int i = this.getContents().size() - 1;
        while (i >= 0) {
            String line = this.getContents().get(i);
            if (line.trim().equals("")) {
                this.getContents().remove(i);
            }
            --i;
        }
        this.contentsAsString = null;
    }

    public void containsInLine(int i, String string) {
        if (this.getContents().get(i).indexOf(string) < 0) {
            throw new Failed("'" + string + "' not found in line " + i + " of file " + this.filename);
        }
    }

    private InputStream getFileIS(String fn) {
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(fn);
        return in;
    }
}

