/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RemoveDateTagAction
extends SelectionListenerAction {
    private IStructuredSelection selection;

    public RemoveDateTagAction() {
        super(CVSUIMessages.RemoveDateTagAction_0);
    }

    public void run() {
        CVSTagElement[] elements = this.getSelectedCVSTagElements();
        if (elements.length == 0) {
            return;
        }
        CVSTagElement[] cVSTagElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CVSTagElement element = cVSTagElementArray[n2];
            RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
            CVSTag tag = element.getTag();
            if (tag.getType() == 3) {
                mgr.removeDateTag(element.getRoot(), tag);
            }
            ++n2;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        boolean b = this.containsDataTag();
        this.setEnabled(b);
        return b;
    }

    private boolean containsDataTag() {
        CVSTagElement[] elements = this.getSelectedCVSTagElements();
        if (elements.length > 0) {
            CVSTagElement[] cVSTagElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CVSTagElement element = cVSTagElementArray[n2];
                CVSTag tag = element.getTag();
                if (tag.getType() == 3) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private CVSTagElement[] getSelectedCVSTagElements() {
        ArrayList<Object> cvsTagElements = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            cvsTagElements = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = TeamAction.getAdapter(elements.next(), CVSTagElement.class);
                if (!(next instanceof CVSTagElement)) continue;
                cvsTagElements.add(next);
            }
        }
        if (cvsTagElements != null && !cvsTagElements.isEmpty()) {
            CVSTagElement[] result = new CVSTagElement[cvsTagElements.size()];
            cvsTagElements.toArray(result);
            return result;
        }
        return new CVSTagElement[0];
    }
}

