/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.sourceform.SourceFormProperties;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.properties.FortranPropertyPage;
import org.eclipse.photran.internal.ui.properties.FortranSourceFormEditor;
import org.eclipse.photran.internal.ui.properties.UIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SourceFormPropertyPage
extends FortranPropertyPage {
    private FortranSourceFormEditor sourceForms;
    private SourceFormProperties properties;

    protected Control createContents(Composite parent) {
        IProject proj = this.getProjectFromElement();
        if (proj == null) {
            Label lbl = new Label(parent, 0);
            lbl.setText(UIMessages.SourceFormPropertyPage_SettingsNotAvailable);
            return lbl;
        }
        this.properties = new SourceFormProperties(proj);
        IPreferenceStore scopedStore = this.properties.getPropertyStore();
        scopedStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SourceFormPropertyPage.this.setDirty();
            }
        });
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Link link = new Link(composite, 0);
        link.setText(UIMessages.SourceFormPropertyPage_LinkText);
        link.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 128).grab(true, false).create());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.eclipse.ui.preferencePages.ContentTypes", null, null).open();
            }
        });
        this.sourceForms = new FortranSourceFormEditor("SourceForms", UIMessages.SourceFormPropertyPage_SourceFormFilenameAssocsLabel, parent);
        this.sourceForms.setPreferenceStore(scopedStore);
        this.sourceForms.load();
        return composite;
    }

    public void performDefaults() {
        this.sourceForms.loadDefault();
    }

    @Override
    public boolean doPerformOk() {
        this.sourceForms.store();
        try {
            this.properties.save();
        }
        catch (IOException e) {
            FortranUIPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)UIMessages.SourceFormPropertyPage_ErrorTitle, (String)(String.valueOf(UIMessages.SourceFormPropertyPage_PropertiesCouldNotBeSaved) + e.getClass().getName() + ": " + e.getMessage()));
        }
        this.touchProject();
        return true;
    }

    private void touchProject() {
        try {
            IProject proj = this.getProjectFromElement();
            proj.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && FortranCorePlugin.hasFortranContentType((IFile)((IFile)resource))) {
                        SourceFormPropertyPage.this.touch((IFile)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            FortranCorePlugin.log((String)UIMessages.SourceFormPropertyPage_ErrorTouchingProject, (Throwable)e);
        }
    }

    private void touch(IFile file) {
        try {
            file.touch((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            FortranCorePlugin.log((String)UIMessages.SourceFormPropertyPage_ErrorTouchingFile, (Throwable)e);
        }
    }
}

