/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.SynchronizeVersionsWizard;
import org.eclipse.ui.PlatformUI;

public class SynchronizeVersionsAction
extends Action {
    private FeatureEditor activeEditor;

    public SynchronizeVersionsAction() {
        this.setText(PDEUIMessages.Actions_synchronizeVersions_label);
    }

    private void ensureContentSaved() {
        if (this.activeEditor.isDirty()) {
            try {
                IRunnableWithProgress op = monitor -> this.activeEditor.doSave(monitor);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        this.ensureContentSaved();
        SynchronizeVersionsWizard wizard = new SynchronizeVersionsWizard(this.activeEditor);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.open();
    }

    public void setActiveEditor(FeatureEditor editor) {
        this.activeEditor = editor;
        IModel model = (IModel)editor.getAggregateModel();
        if (model != null) {
            this.setEnabled(model.isEditable());
        }
    }
}

