/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.m2m.atl.adt.debug.AtlDebugPlugin;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.AtlBreakpoint;
import org.eclipse.m2m.atl.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.debug.core.AtlStackFrame;
import org.eclipse.m2m.atl.debug.core.AtlThread;
import org.eclipse.m2m.atl.debug.core.AtlVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class AtlDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final int BREAKPOINT = 5;
    static final URL BASE_URL = AtlDebugPlugin.getDefault().getBundle().getEntry("/");
    static final String ICON_PATH = "icons/";
    private Map<Integer, Image> mapImage;
    private Map<String, Object> fAttributes = new HashMap<String, Object>(3);

    private boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.fAttributes.put(attribute, value);
    }

    private Image createImage(String path) {
        try {
            URL url = new URL(BASE_URL, path);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private void initMapImage() {
        this.mapImage = new HashMap<Integer, Image>();
        this.mapImage.put(new Integer(2), null);
        this.mapImage.put(new Integer(4), null);
        this.mapImage.put(new Integer(0), null);
        this.mapImage.put(new Integer(1), null);
        this.mapImage.put(new Integer(3), null);
        this.mapImage.put(new Integer(5), null);
    }

    public Image getImage(Object item) {
        if (this.mapImage == null) {
            this.initMapImage();
        }
        if (item instanceof AtlVariable) {
            String imageName = null;
            AtlVariable atlVar = (AtlVariable)item;
            switch (atlVar.getDescription()) {
                case 2: {
                    imageName = "attribute.gif";
                    break;
                }
                case 4: {
                    imageName = "element.gif";
                    break;
                }
                case 0: {
                    imageName = "localVariable.gif";
                    break;
                }
                case 1: {
                    imageName = "reference.gif";
                    break;
                }
                case 3: {
                    imageName = "supertype.gif";
                    break;
                }
                default: {
                    return null;
                }
            }
            if (this.mapImage.get(new Integer(atlVar.getDescription())) == null) {
                this.mapImage.put(new Integer(atlVar.getDescription()), this.createImage(ICON_PATH + imageName));
            }
            return this.mapImage.get(new Integer(atlVar.getDescription()));
        }
        if (item instanceof AtlBreakpoint) {
            if (this.mapImage.get(new Integer(5)) == null) {
                this.mapImage.put(new Integer(5), this.createImage("icons/breakpoint.gif"));
            }
            return this.mapImage.get(new Integer(5));
        }
        if (item instanceof IMarker) {
            if (this.mapImage.get(new Integer(5)) == null) {
                this.mapImage.put(new Integer(5), this.createImage("icons/breakpoint.gif"));
            }
            return this.mapImage.get(new Integer(5));
        }
        return null;
    }

    public String getText(Object item) {
        if (item instanceof AtlDebugTarget) {
            AtlDebugTarget target = (AtlDebugTarget)item;
            String name = "";
            try {
                name = target.getName();
            }
            catch (DebugException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            return String.valueOf(name) + Messages.getString("AtlDebugModelPresentation.CONNECTEDONHOST") + target.getHost() + Messages.getString("AtlDebugModelPresentation.PORT") + target.getPort();
        }
        if (item instanceof AtlThread) {
            AtlThread thread = (AtlThread)item;
            try {
                String currentState;
                String message = "";
                switch (((AtlDebugTarget)thread.getDebugTarget()).getState()) {
                    case 3: {
                        currentState = Messages.getString("AtlDebugModelPresentation.DISCONNECTED");
                        break;
                    }
                    case 1: {
                        currentState = Messages.getString("AtlDebugModelPresentation.RUNNING");
                        break;
                    }
                    case 2: {
                        String currentState2 = Messages.getString("AtlDebugModelPresentation.SUSPENDED");
                        message = ((AtlDebugTarget)thread.getDebugTarget()).getMessageFromDebuggee();
                        return String.valueOf(thread.getName()) + " (" + currentState2 + " (" + message + "))";
                    }
                    case 0: {
                        currentState = Messages.getString("AtlDebugModelPresentation.TERMINATED");
                        break;
                    }
                    default: {
                        currentState = Messages.getString("AtlDebugModelPresentation.UNKNOWN");
                    }
                }
                return String.valueOf(thread.getName()) + " (" + currentState + ")";
            }
            catch (DebugException e) {
                return null;
            }
        }
        if (item instanceof AtlStackFrame) {
            return null;
        }
        if (item instanceof AtlVariable) {
            AtlVariable atlVar = (AtlVariable)item;
            String typeVar = null;
            try {
                typeVar = this.isShowVariableTypeNames() ? atlVar.getReferenceTypeName() : "";
                String rtn = atlVar.getValue().getReferenceTypeName();
                if (rtn.equals("Boolean") || rtn.equals("Integer") || rtn.equals("Real")) {
                    return String.valueOf(typeVar) + " " + atlVar.getName() + " = " + atlVar.getValue().getValueString();
                }
                if (rtn.equals("String")) {
                    return String.valueOf(typeVar) + " " + atlVar.getName() + " = '" + atlVar.getValue().getValueString() + "'";
                }
                if (rtn.equals("EnumLiteral")) {
                    return String.valueOf(typeVar) + " " + atlVar.getName() + " = #" + atlVar.getValue().getValueString();
                }
                if (rtn.equals("Map Element")) {
                    return atlVar.getName();
                }
                return String.valueOf(typeVar) + " " + atlVar.getName() + " = " + atlVar.getReferenceTypeName() + " (id = " + atlVar.getIdVariable() + ")";
            }
            catch (DebugException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (item instanceof AtlBreakpoint) {
            IMarker marker = ((AtlBreakpoint)item).getMarker();
            try {
                String location = marker.getResource().getName();
                Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
                Integer charStart = (Integer)marker.getAttribute("charStart");
                Integer charEnd = (Integer)marker.getAttribute("charEnd");
                return String.valueOf(location) + " [line: " + lineNumber + ", charStart: " + charStart + ", charEnd: " + charEnd + "]";
            }
            catch (CoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            listener.detailComputed(value, value.getValueString());
        }
        catch (DebugException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public IEditorInput getDisassemblyEditorInput(AtlStackFrame frame) {
        DisassemblyEditorInput ret = null;
        ret = new DisassemblyEditorInput(frame.getDisassembled());
        return ret;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof AtlStackFrame) {
            AtlStackFrame frame = (AtlStackFrame)element;
            if (((AtlDebugTarget)frame.getDebugTarget()).isDisassemblyMode()) {
                return this.getDisassemblyEditorInput(frame);
            }
            return new FileEditorInput(frame.getSourcefile());
        }
        if (element instanceof AtlBreakpoint) {
            IMarker marker = ((AtlBreakpoint)element).getMarker();
            IFile ifile = (IFile)marker.getResource();
            return new FileEditorInput(ifile);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof DisassemblyEditorInput) {
            return "org.eclipse.ui.DefaultTextEditor";
        }
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisassemblyEditorInput
    implements IStorageEditorInput {
        private IStorage contents;

        public DisassemblyEditorInput(IStorage contents) {
            this.contents = contents;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.contents.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.contents.getName();
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.contents;
        }
    }
}

