/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.pde.CacheManager;
import org.eclipse.pde.core.target.TargetBundle;

public class MavenSourceBundle
extends TargetBundle {
    public static final String ECLIPSE_SOURCE_BUNDLE_HEADER = "Eclipse-SourceBundle";

    public MavenSourceBundle(final BundleInfo sourceTarget, Artifact artifact, CacheManager cacheManager) throws Exception {
        Manifest manifest;
        this.fSourceTarget = sourceTarget;
        this.fInfo.setSymbolicName(String.valueOf(sourceTarget.getSymbolicName()) + ".source");
        this.fInfo.setVersion(sourceTarget.getVersion());
        final File sourceFile = artifact.getFile();
        Throwable throwable = null;
        Object var7_7 = null;
        try (JarFile jar = new JarFile(sourceFile);){
            manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (MavenSourceBundle.isValidSourceManifest(manifest)) {
            this.fInfo.setLocation(sourceFile.toURI());
        } else {
            File generatedSourceBundle = cacheManager.accessArtifactFile(artifact, new CacheManager.CacheConsumer<File>(){

                @Override
                public File consume(File file) throws Exception {
                    if (CacheManager.isOutdated(file, sourceFile)) {
                        Attributes attr = manifest.getMainAttributes();
                        if (attr.isEmpty()) {
                            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                        }
                        attr.putValue(MavenSourceBundle.ECLIPSE_SOURCE_BUNDLE_HEADER, String.valueOf(sourceTarget.getSymbolicName()) + ";version=\"" + sourceTarget.getVersion() + "\";roots:=\".\"");
                        attr.putValue("Bundle-ManifestVersion", "2");
                        attr.putValue("Bundle-Name", "Source Bundle for " + sourceTarget.getSymbolicName() + ":" + sourceTarget.getVersion());
                        attr.putValue("Bundle-SymbolicName", MavenSourceBundle.this.fInfo.getSymbolicName());
                        attr.putValue("Bundle-Version", MavenSourceBundle.this.fInfo.getVersion());
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);){
                            Throwable throwable2 = null;
                            Object var7_10 = null;
                            try (JarFile jar = new JarFile(sourceFile);){
                                Enumeration<JarEntry> entries = jar.entries();
                                while (entries.hasMoreElements()) {
                                    JarEntry jarEntry = entries.nextElement();
                                    if ("META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                                    Throwable throwable3 = null;
                                    Object var12_17 = null;
                                    try (InputStream is = jar.getInputStream(jarEntry);){
                                        stream.putNextEntry(new ZipEntry(jarEntry.getName()));
                                        is.transferTo(stream);
                                        stream.closeEntry();
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    return file;
                }
            });
            this.fInfo.setLocation(generatedSourceBundle.toURI());
        }
    }

    private static boolean isValidSourceManifest(Manifest manifest) {
        if (manifest != null) {
            return manifest.getMainAttributes().getValue(ECLIPSE_SOURCE_BUNDLE_HEADER) != null;
        }
        return false;
    }
}

