/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.list.MutableListFactory;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.FastList;

public class MutableListFactoryImpl
implements MutableListFactory {
    public static final MutableListFactory INSTANCE = new MutableListFactoryImpl();

    @Override
    public <T> MutableList<T> empty() {
        return FastList.newList();
    }

    @Override
    public <T> MutableList<T> with(T ... items) {
        return FastList.newListWith(items);
    }

    @Override
    public <T> MutableList<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return FastList.newList(capacity);
    }

    @Override
    public <T> MutableList<T> withAll(Iterable<? extends T> iterable) {
        return FastList.newList(iterable);
    }

    @Override
    public <T> MutableList<T> withNValues(int size, Function0<? extends T> factory) {
        return FastList.newWithNValues(size, factory);
    }

    @Override
    public <T> MutableList<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(FastList::newList));
    }
}

