/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.visitor.ValidatorVisitor;

public class ValidatorBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    private String natureId = null;

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        if (this.natureId != null) {
            return new ValidatorBuildParticipant();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class ValidatorBuildParticipant
    implements IBuildParticipant {
        private ValidatorBuildParticipant() {
        }

        public void build(IBuildContext context) throws CoreException {
            if (!this.isValidatorEnabled(context)) {
                return;
            }
            try {
                ModelManager.getModelManager().getIndexManager().waitUntilReady();
                ModuleDeclaration moduleDeclaration = this.getModuleDeclaration(context);
                if (moduleDeclaration != null) {
                    moduleDeclaration.traverse((ASTVisitor)new ValidatorVisitor(context));
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
        }

        private ModuleDeclaration getModuleDeclaration(IBuildContext context) {
            return (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        }

        private boolean isValidatorEnabled(IBuildContext context) throws CoreException {
            IModelElement module;
            if (Boolean.TRUE.equals(context.get("IN_LIBRARY_FOLDER"))) {
                return false;
            }
            return context.getModelElement() == null || !(module = context.getModelElement()).isReadOnly() && module.getScriptProject() != null && module.getScriptProject().isOnBuildpath(module);
        }
    }
}

