/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.libfolders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.core.libfolders.ILibraryFolderChangeListener;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.libfolders.AutoDetectLibraryFolderListener;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.DisabledResourceManager;

public class LibraryFolderManager {
    private static LibraryFolderManager instance;
    private Collection<ILibraryFolderChangeListener> listeners;
    private AutoDetectLibraryFolderListener listener = new AutoDetectLibraryFolderListener();

    private LibraryFolderManager() {
        this.listeners = Collections.synchronizedSet(new HashSet());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
    }

    public static synchronized LibraryFolderManager getInstance() {
        if (instance == null) {
            instance = new LibraryFolderManager();
        }
        return instance;
    }

    public void addListener(ILibraryFolderChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILibraryFolderChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void useAsLibraryFolder(IFolder[] folders, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException, CoreException {
        this.disableValidation(folders);
        folders = this.removeNonExisting(folders);
        if (folders.length > 0) {
            this.notifyListeners(folders);
            this.waitValidationJobs(monitor);
            this.deleteMarkers((IResource[])folders);
        }
    }

    public void useAsSourceFolder(IFolder[] folders, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException, CoreException {
        this.enableValidation(folders);
        folders = this.removeNonExisting(folders);
        if (folders.length > 0) {
            this.notifyListeners(folders);
            this.waitValidationJobs(monitor);
            this.revalidate((IResource[])folders, monitor);
        }
    }

    public void enableValidation(IFolder folder) {
        ValidationFramework vf = ValidationFramework.getDefault();
        vf.enableValidation((IResource)folder);
    }

    public void disableValidation(IFolder folder) throws CoreException {
        ValidationFramework vf = ValidationFramework.getDefault();
        IFolder[] iFolderArray = this.getAllSubfolders(folder);
        int n = iFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder subfolder = iFolderArray[n2];
            vf.enableValidation((IResource)subfolder);
            ++n2;
        }
        if (!this.isInLibraryFolder((IResource)folder)) {
            vf.disableValidation((IResource)folder);
        }
    }

    public void enableValidation(IFolder[] folders) {
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            this.enableValidation(folder);
            ++n2;
        }
    }

    public void disableValidation(IFolder[] folders) throws CoreException {
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            this.disableValidation(folder);
            ++n2;
        }
    }

    public boolean isInLibraryFolder(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 1) {
            resource = resource.getParent();
        }
        while (resource.getType() == 2) {
            if (this.isExplicitlyDisabled((IFolder)resource)) {
                return true;
            }
            resource = resource.getParent();
        }
        return false;
    }

    public boolean isExplicitlyDisabled(IFolder folder) {
        if (folder == null) {
            return false;
        }
        return DisabledResourceManager.getDefault().isDisabled((IResource)folder);
    }

    public IFolder getExplicitlyDisabledParent(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 1) {
            resource = resource.getParent();
        }
        while (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            if (this.isExplicitlyDisabled(folder)) {
                return folder;
            }
            resource = resource.getParent();
        }
        return null;
    }

    public IFolder[] getAllSubfolders(IFolder[] folders) throws CoreException {
        HashSet<IFolder> allSubfolders = new HashSet<IFolder>();
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            allSubfolders.addAll(Arrays.asList(this.getAllSubfolders(folder)));
            ++n2;
        }
        return allSubfolders.toArray(new IFolder[allSubfolders.size()]);
    }

    public IFolder[] getAllSubfolders(IFolder folder) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        this.collectAllSubfolders(folder, result);
        return result.toArray(new IFolder[result.size()]);
    }

    public void suspendDetection(IProject project, boolean suspend) {
        this.listener.suspendDetection(project, suspend);
    }

    public void suspendAllDetection(boolean suspend) {
        this.listener.suspendAllDetection(suspend);
    }

    private void collectAllSubfolders(IFolder folder, Collection<IFolder> result) throws CoreException {
        result.add(folder);
        if (!folder.exists()) {
            return;
        }
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child.getType() == 2) {
                this.collectAllSubfolders((IFolder)child, result);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(IFolder[] folders) {
        Collection<ILibraryFolderChangeListener> collection = this.listeners;
        synchronized (collection) {
            for (ILibraryFolderChangeListener listener : this.listeners) {
                try {
                    listener.foldersChanged(folders);
                }
                catch (Exception e) {
                    PHPCorePlugin.log(e);
                }
            }
        }
    }

    private IFolder[] removeNonExisting(IFolder[] folders) {
        HashSet<IFolder> existing = new HashSet<IFolder>();
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            if (folder.exists()) {
                existing.add(folder);
            }
            ++n2;
        }
        return existing.toArray(new IFolder[existing.size()]);
    }

    private void deleteMarkers(IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            resource.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            ++n2;
        }
    }

    private void revalidate(IResource[] resources, IProgressMonitor monitor) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.deepTouch(resource, monitor);
            ++n2;
        }
    }

    private void deepTouch(IResource resource, IProgressMonitor monitor) throws CoreException {
        resource.touch(monitor);
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.deepTouch(member, monitor);
                ++n2;
            }
        }
    }

    private void waitValidationJobs(IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
    }
}

