/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui;

import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.arm.core.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SetCrossCommandWizardPage
extends MBSCustomPage {
    private Composite fComposite;
    private boolean fFinish = false;
    private Text fPathTxt;
    private Combo fToolchainCombo;
    private int fSelectedToolchainIndex;
    private String fSelectedToolchainName;
    public static final String PAGE_ID = "org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.setCrossCommandWizardPage";
    public static final String CROSS_WIZARD = "wizard";
    public static final String CROSS_PROJECT_NAME = "projectName";
    public static final String CROSS_TOOLCHAIN_NAME = "toolchain.name";
    public static final String CROSS_TOOLCHAIN_PATH = "toolchain.path";

    public SetCrossCommandWizardPage() {
        this.pageID = PAGE_ID;
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_PATH, (Object)"");
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_NAME, (Object)"");
    }

    protected boolean isCustomPageComplete() {
        this.updateProjectNameProperty();
        return this.fFinish;
    }

    public String getName() {
        return Messages.SetCrossCommandWizardPage_name;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_WIZARD, (Object)newWizard);
    }

    public void createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData();
        this.fComposite.setLayoutData((Object)layoutData);
        Label toolchainLbl = new Label(this.fComposite, 0);
        toolchainLbl.setText(Messages.SetCrossCommandWizardPage_toolchain);
        this.fToolchainCombo = new Combo(this.fComposite, 4);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.fToolchainCombo.setLayoutData((Object)layoutData);
        String[] toolchains = new String[ToolchainDefinition.getSize()];
        int i = 0;
        while (i < ToolchainDefinition.getSize()) {
            toolchains[i] = ToolchainDefinition.getToolchain((int)i).getFullName();
            ++i;
        }
        this.fToolchainCombo.setItems(toolchains);
        final PersistentPreferences persistentPreferences = Activator.getInstance().getPersistentPreferences();
        try {
            this.fSelectedToolchainName = persistentPreferences.getToolchainName();
            if (this.fSelectedToolchainName != null && this.fSelectedToolchainName.length() > 0) {
                try {
                    this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName((String)this.fSelectedToolchainName);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.fSelectedToolchainIndex = ToolchainDefinition.getDefault();
                }
            } else {
                this.fSelectedToolchainIndex = ToolchainDefinition.getDefault();
                this.fSelectedToolchainName = ToolchainDefinition.getToolchain((int)this.fSelectedToolchainIndex).getName();
            }
        }
        catch (Exception exception) {
            this.fSelectedToolchainIndex = 0;
        }
        this.updateToolchainNameProperty();
        String toolchainSel = toolchains[this.fSelectedToolchainIndex];
        this.fToolchainCombo.setText(toolchainSel);
        this.fToolchainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetCrossCommandWizardPage.this.fSelectedToolchainIndex = SetCrossCommandWizardPage.this.fToolchainCombo.getSelectionIndex();
                SetCrossCommandWizardPage.this.fSelectedToolchainName = ToolchainDefinition.getToolchain((int)SetCrossCommandWizardPage.this.fSelectedToolchainIndex).getName();
                SetCrossCommandWizardPage.this.updateToolchainNameProperty();
                String crossCommandPath = persistentPreferences.getToolchainPath(SetCrossCommandWizardPage.this.fSelectedToolchainName, null);
                SetCrossCommandWizardPage.this.fPathTxt.setText(crossCommandPath);
            }
        });
        Label label = new Label(this.fComposite, 0);
        label.setText(Messages.SetCrossCommandWizardPage_path);
        this.fPathTxt = new Text(this.fComposite, 2052);
        String crossCommandPath = persistentPreferences.getToolchainPath(this.fSelectedToolchainName, null);
        this.fPathTxt.setText(crossCommandPath);
        this.updatePathProperty();
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fPathTxt.setLayoutData((Object)layoutData);
        this.fPathTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetCrossCommandWizardPage.this.updatePathProperty();
            }
        });
        Button button = new Button(this.fComposite, 0);
        button.setText(Messages.SetCrossCommandWizardPage_browse);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(SetCrossCommandWizardPage.this.fComposite.getShell(), 65536);
                String browsedDirectory = dirDialog.open();
                SetCrossCommandWizardPage.this.fPathTxt.setText(browsedDirectory);
            }
        });
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        button.setLayoutData((Object)layoutData);
    }

    public Control getControl() {
        return this.fComposite;
    }

    public String getDescription() {
        return Messages.SetCrossCommandWizardPage_description;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return this.wizard.getDefaultPageImage();
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return Messages.SetCrossCommandWizardPage_title;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fFinish = true;
        }
        this.fComposite.setVisible(visible);
    }

    public void dispose() {
    }

    private void updatePathProperty() {
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_PATH, (Object)this.fPathTxt.getText());
    }

    private void updateToolchainNameProperty() {
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_NAME, (Object)this.fSelectedToolchainName);
    }

    private void updateProjectNameProperty() {
        String name = SetCrossCommandWizardPage.getProjectName(this.getWizard());
        if (name != null) {
            MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_PROJECT_NAME, (Object)name);
        }
    }

    public static String getProjectName(IWizard wizard) {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = wizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage wizardPage = iWizardPageArray[n2];
            if (wizardPage instanceof WizardNewProjectCreationPage) {
                return ((WizardNewProjectCreationPage)wizardPage).getProjectName();
            }
            ++n2;
        }
        return null;
    }
}

