/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeFilter
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(DatatypeFilter.class);
    private final IRI datatype;
    private final CoreDatatype.XSD xsdDatatype;
    private StackTraceElement[] stackTrace;

    public DatatypeFilter(PlanNode parent, IRI datatype, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.datatype = datatype;
        this.xsdDatatype = CoreDatatype.from(datatype).asXSDDatatype().orElse(null);
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        boolean isEqual;
        if (!t.get().getValue().isLiteral()) {
            logger.debug("Tuple rejected because it's not a literal. Tuple: {}", (Object)t);
            return false;
        }
        Literal literal = (Literal)t.get().getValue();
        if (this.xsdDatatype != null) {
            if (literal.getCoreDatatype() == this.xsdDatatype) {
                boolean isValid = XMLDatatypeUtil.isValidValue(literal.stringValue(), this.xsdDatatype);
                if (isValid) {
                    logger.trace("Tuple accepted because its literal value is valid according to the rules for the datatype in the XSD spec. Actual datatype: {}, Expected datatype: {}, Tuple: {}", new Object[]{literal.getDatatype(), this.xsdDatatype, t});
                } else {
                    logger.debug("Tuple rejected because its literal value is invalid according to the rules for the datatype in the XSD spec. Actual datatype: {}, Expected datatype: {}, Tuple: {}", new Object[]{literal.getDatatype(), this.xsdDatatype, t});
                }
                return isValid;
            }
            logger.debug("Tuple rejected because literal's core datatype is not the expected datatype. Actual datatype: {}, Expected datatype: {}, Tuple: {}", new Object[]{literal.getDatatype(), this.xsdDatatype, t});
            return false;
        }
        boolean bl = isEqual = literal.getDatatype() == this.datatype || literal.getDatatype().equals(this.datatype);
        if (isEqual) {
            logger.trace("Tuple accepted because literal's datatype is equal to the expected datatype. Actual datatype: {}, Expected datatype: {}, Tuple: {}", new Object[]{literal.getDatatype(), this.datatype, t});
        } else {
            logger.debug("Tuple rejected because literal's datatype is not equal to the expected datatype. Actual datatype: {}, Expected datatype: {}, Tuple: {}", new Object[]{literal.getDatatype(), this.datatype, t});
        }
        return isEqual;
    }

    @Override
    public String toString() {
        return "DatatypeFilter{datatype=" + Formatter.prefix(this.datatype) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatatypeFilter that = (DatatypeFilter)o;
        return this.datatype.equals(that.datatype);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.datatype);
    }
}

