/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;

public class CorruptLiteral
extends CorruptValue
implements Literal {
    private static final long serialVersionUID = -2510885288827542623L;
    private static final IRI CORRUPT = Values.iri("urn:corrupt");

    public CorruptLiteral(ValueStoreRevision revision, int internalID, byte[] data) {
        super(revision, internalID, data);
    }

    @Override
    public String stringValue() {
        return "CorruptLiteral_with_ID_" + this.getInternalID() + ": " + this.getLabel();
    }

    @Override
    public String getLabel() {
        block16: {
            byte[] data = this.getData();
            try {
                if (data == null || data.length <= 0) break block16;
                boolean allZero = true;
                for (byte b : data) {
                    if (b == 0) continue;
                    allZero = false;
                    break;
                }
                if (allZero) {
                    return "All " + data.length + " data bytes are 0x00";
                }
                String prefix = this.getClass().getSimpleName() + " with ID " + this.getInternalID() + " with possible data: ";
                data = CorruptLiteral.truncateData(data);
                try {
                    String utf8 = new String(data, StandardCharsets.UTF_8);
                    if (utf8.indexOf(65533) < 0) {
                        return prefix + utf8;
                    }
                }
                catch (Throwable utf8) {
                    // empty catch block
                }
                String recoveredUtf8 = null;
                int bestLen = 0;
                block7: for (int start = 0; start < data.length; ++start) {
                    int len;
                    for (int end = data.length; end > start && (len = end - start) > bestLen; --end) {
                        try {
                            String s = new String(data, start, len, StandardCharsets.UTF_8);
                            if (s.indexOf(65533) >= 0) continue;
                            recoveredUtf8 = s;
                            bestLen = len;
                            continue block7;
                        }
                        catch (Throwable s) {
                            // empty catch block
                        }
                    }
                }
                if (recoveredUtf8 != null && !recoveredUtf8.isEmpty()) {
                    return prefix + recoveredUtf8;
                }
                int bestAsciiStart = -1;
                int bestAsciiLen = 0;
                int i = 0;
                while (i < data.length) {
                    if (data[i] >= 32 && data[i] <= 126) {
                        int runStart = i;
                        while (i < data.length && data[i] >= 32 && data[i] <= 126) {
                            ++i;
                        }
                        int runLen = i - runStart;
                        if (runLen <= bestAsciiLen) continue;
                        bestAsciiLen = runLen;
                        bestAsciiStart = runStart;
                        continue;
                    }
                    ++i;
                }
                if (bestAsciiLen > 0) {
                    String ascii = new String(data, bestAsciiStart, bestAsciiLen, StandardCharsets.US_ASCII);
                    return prefix + ascii;
                }
                return prefix + Hex.encodeHexString((byte[])Arrays.copyOfRange(data, 0, data.length));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getClass().getSimpleName() + " with ID " + this.getInternalID();
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.empty();
    }

    @Override
    public IRI getDatatype() {
        return CORRUPT;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte byteValue() {
        return 0;
    }

    @Override
    public short shortValue() {
        return 0;
    }

    @Override
    public int intValue() {
        return 0;
    }

    @Override
    public long longValue() {
        return 0L;
    }

    @Override
    public BigInteger integerValue() {
        return null;
    }

    @Override
    public BigDecimal decimalValue() {
        return null;
    }

    @Override
    public float floatValue() {
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return null;
    }

    @Override
    public CoreDatatype getCoreDatatype() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        CorruptLiteral otherCorruptValue;
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptLiteral && this.getInternalID() != -1 && (otherCorruptValue = (CorruptLiteral)o).getInternalID() != -1 && this.getValueStoreRevision().equals(otherCorruptValue.getValueStoreRevision())) {
            return this.getInternalID() == otherCorruptValue.getInternalID();
        }
        return super.equals(o);
    }
}

