/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;

public class BackgroundGraphResult
extends IterationWrapper<Statement>
implements GraphQueryResult,
Runnable,
RDFHandler {
    private final RDFParser parser;
    private final Charset charset;
    private final InputStream in;
    private final String baseURI;
    private final CountDownLatch namespacesReady = new CountDownLatch(1);
    private final CountDownLatch finishedParsing = new CountDownLatch(1);
    private final Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private final QueueCursor<Statement> queue;

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI) {
        super(queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.queue.done();
        }
        try {
            this.finishedParsing.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.queue.checkException();
        }
    }

    @Override
    public void run() {
        try {
            try {
                this.parser.setRDFHandler(this);
                if (this.charset == null) {
                    this.parser.parse(this.in, this.baseURI);
                } else {
                    this.parser.parse(new InputStreamReader(this.in, this.charset), this.baseURI);
                }
            }
            finally {
                this.in.close();
            }
        }
        catch (Exception e) {
            this.queue.toss(e);
        }
        finally {
            this.queue.done();
            this.namespacesReady.countDown();
            this.finishedParsing.countDown();
        }
    }

    @Override
    public void startRDF() throws RDFHandlerException {
    }

    @Override
    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            Map<String, String> map = Collections.unmodifiableMap(this.namespaces);
            return map;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.queue.checkException();
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.queue.toss(e);
            this.queue.done();
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

