/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SubQueryValueOperator;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class FilterIterator
extends FilterIteration<BindingSet> {
    private final QueryValueEvaluationStep condition;
    private final EvaluationStrategy strategy;
    private final Function<BindingSet, BindingSet> retain;

    public static QueryEvaluationStep supply(Filter filter, EvaluationStrategy strategy, QueryEvaluationContext context) {
        QueryValueEvaluationStep ves;
        QueryEvaluationStep arg = strategy.precompile(filter.getArg(), context);
        try {
            ves = strategy.precompile(filter.getCondition(), context);
        }
        catch (QueryEvaluationException e) {
            return QueryEvaluationStep.EMPTY;
        }
        Function<Object, Object> retain = !FilterIterator.isPartOfSubQuery(filter) ? FilterIterator.buildRetainFunction(filter, context) : Function.identity();
        return bs -> new FilterIterator(arg.evaluate(bs), ves, strategy, retain);
    }

    public FilterIterator(Filter filter, CloseableIteration<BindingSet> iter, QueryValueEvaluationStep condition, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(iter);
        this.condition = condition;
        this.strategy = strategy;
        this.retain = !FilterIterator.isPartOfSubQuery(filter) ? bs -> {
            QueryBindingSet nbs = new QueryBindingSet((BindingSet)bs);
            nbs.retainAll(filter.getBindingNames());
            return nbs;
        } : Function.identity();
    }

    private FilterIterator(CloseableIteration<BindingSet> iter, QueryValueEvaluationStep condition, EvaluationStrategy strategy, Function<BindingSet, BindingSet> retain) throws QueryEvaluationException {
        super(iter);
        this.condition = condition;
        this.strategy = strategy;
        this.retain = retain;
    }

    private static Function<BindingSet, BindingSet> buildRetainFunction(Filter filter, QueryEvaluationContext context) {
        Set<String> bindingNames = filter.getBindingNames();
        Predicate[] hasBinding = new Predicate[bindingNames.size()];
        BiConsumer[] setBinding = new BiConsumer[bindingNames.size()];
        Iterator<String> bi = bindingNames.iterator();
        int i = 0;
        while (bi.hasNext()) {
            String bindingName = bi.next();
            hasBinding[i] = context.hasBinding(bindingName);
            Function<BindingSet, Value> getValue = context.getValue(bindingName);
            setBinding[i] = (bs, nbs) -> nbs.setBinding(bindingName, (Value)getValue.apply((BindingSet)bs));
            ++i;
        }
        return bs -> {
            MutableBindingSet nbs = context.createBindingSet();
            for (int i = 0; i < hasBinding.length; ++i) {
                if (!hasBinding[i].test(bs)) continue;
                setBinding[i].accept(bs, nbs);
            }
            return nbs;
        };
    }

    @Override
    protected boolean accept(BindingSet bindings) throws QueryEvaluationException {
        try {
            BindingSet scopeBindings = this.retain.apply(bindings);
            return this.strategy.isTrue(this.condition, scopeBindings);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    public static boolean isPartOfSubQuery(QueryModelNode node) {
        if (node instanceof SubQueryValueOperator) {
            return true;
        }
        QueryModelNode parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        return FilterIterator.isPartOfSubQuery(parent);
    }

    @Override
    protected void handleClose() {
    }
}

