/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.CleanerGraphQueryResult;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.CleanerTupleQueryResult;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.BackgroundGraphResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.helpers.BackgroundTupleResult;
import org.eclipse.rdf4j.rio.RDFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundResultExecutor
implements AutoCloseable {
    private static final ConcurrentCleaner cleaner = new ConcurrentCleaner();
    private final Logger logger = LoggerFactory.getLogger(BackgroundResultExecutor.class);
    private final ExecutorService executor;
    private final HashSet<QueryResult<?>> executing = new HashSet();

    public BackgroundResultExecutor(ExecutorService executor) {
        this.executor = Objects.requireNonNull(executor, "Executor service was null");
    }

    public TupleQueryResult parse(TupleQueryResultParser parser, InputStream in, WeakReference<?> callerReference) {
        BackgroundTupleResult result = new BackgroundTupleResult(parser, in);
        this.autoCloseRunnable(result, result);
        return new CleanerTupleQueryResult(result, cleaner);
    }

    public GraphQueryResult parse(RDFParser parser, InputStream in, Charset charset, String baseURI, WeakReference<?> callerReference) {
        BackgroundGraphResult result = new BackgroundGraphResult(parser, in, charset, baseURI);
        this.autoCloseRunnable(result, result);
        return new CleanerGraphQueryResult(result, cleaner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashSet<QueryResult<?>> hashSet = this.executing;
        synchronized (hashSet) {
            for (AutoCloseable autoCloseable : this.executing) {
                try {
                    autoCloseable.close();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.logger.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCloseRunnable(QueryResult<?> result, Runnable runner) {
        HashSet<QueryResult<?>> hashSet = this.executing;
        synchronized (hashSet) {
            this.executing.add(result);
        }
        this.executor.execute(() -> {
            try {
                runner.run();
            }
            finally {
                HashSet<QueryResult<?>> hashSet = this.executing;
                synchronized (hashSet) {
                    this.executing.remove(result);
                }
            }
        });
    }
}

