/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.BoundJoinTupleExpr;
import org.eclipse.rdf4j.federated.algebra.NodeFactory;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.repository.RepositoryException;

public class CheckStatementPattern
implements StatementTupleExpr,
BoundJoinTupleExpr {
    private static final long serialVersionUID = -4063951571744144255L;
    protected final StatementTupleExpr stmt;
    protected final String id;
    protected final QueryInfo queryInfo;
    private double resultSizeEstimate = -1.0;
    private double costEstimate = -1.0;
    private long resultSizeActual = -1L;
    private long totalTimeNanosActual = -1L;

    public CheckStatementPattern(StatementTupleExpr stmt, QueryInfo queryInfo) {
        this.stmt = stmt;
        this.id = NodeFactory.getNextId();
        this.queryInfo = queryInfo;
    }

    public StatementPattern getStatementPattern() {
        return (StatementPattern)((Object)this.stmt);
    }

    @Override
    public int getFreeVarCount() {
        return 0;
    }

    @Override
    public List<String> getFreeVars() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<StatementSource> getStatementSources() {
        return this.stmt.getStatementSources();
    }

    @Override
    public boolean hasFreeVarsFor(BindingSet binding) {
        return false;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        return this.stmt.getAssuredBindingNames();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.stmt.getBindingNames();
    }

    @Override
    public QueryModelNode getParentNode() {
        return this.stmt.getParentNode();
    }

    @Override
    public String getSignature() {
        return this.stmt.getSignature();
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        this.stmt.replaceChildNode(current, replacement);
    }

    @Override
    public void replaceWith(QueryModelNode replacement) {
        this.stmt.replaceWith(replacement);
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        this.stmt.setParentNode(parent);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        this.stmt.visit(visitor);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.stmt.visitChildren(visitor);
    }

    @Override
    public CheckStatementPattern clone() {
        throw new RuntimeException("Operation not supported on this node!");
    }

    @Override
    public double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    @Override
    public void setResultSizeEstimate(double resultSizeEstimate) {
        this.resultSizeEstimate = resultSizeEstimate;
    }

    @Override
    public long getResultSizeActual() {
        return this.resultSizeActual;
    }

    @Override
    public void setResultSizeActual(long resultSizeActual) {
        this.resultSizeActual = resultSizeActual;
    }

    @Override
    public double getCostEstimate() {
        return this.costEstimate;
    }

    @Override
    public void setCostEstimate(double costEstimate) {
        this.costEstimate = costEstimate;
    }

    @Override
    public long getTotalTimeNanosActual() {
        return this.totalTimeNanosActual;
    }

    @Override
    public void setTotalTimeNanosActual(long totalTimeNanosActual) {
        this.totalTimeNanosActual = totalTimeNanosActual;
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bindings) throws QueryEvaluationException {
        StatementPattern st = (StatementPattern)((Object)this.stmt);
        try {
            for (StatementSource source : this.stmt.getStatementSources()) {
                Endpoint ownedEndpoint = this.queryInfo.getFederationContext().getEndpointManager().getEndpoint(source.getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                if (!t.hasStatements(st, bindings, this.queryInfo, this.queryInfo.getDataset())) continue;
                return new SingleBindingSetIteration(bindings);
            }
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
        return new EmptyIteration<BindingSet>();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stmt.getQueryInfo();
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setOrder(Var var) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Var getOrder() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

