/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EDiffNode;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;

public class R4EReviewItemCompareEditorInput
extends R4ECompareEditorInput {
    private static final String R4E_REVIEW_ITEM_COMPARE_EDITOR_TITLE = "R4E Compare Review Item ";
    private final R4EUIReviewItem fBaseReviewItem;
    private final R4EUIReviewItem fTargetReviewItem;
    private DiffNode fRootNode;

    public R4EReviewItemCompareEditorInput(R4EUIReviewItem aTargetReviewItem, R4EUIReviewItem aBaseReviewItem) {
        this.fTargetReviewItem = aTargetReviewItem;
        this.fBaseReviewItem = aBaseReviewItem;
        this.initConfiguration();
        this.setTitle(R4E_REVIEW_ITEM_COMPARE_EDITOR_TITLE + aTargetReviewItem.getName() + " with " + aBaseReviewItem.getName());
    }

    protected void initConfiguration() {
        this.getCompareConfiguration().setLeftEditable(false);
        this.getCompareConfiguration().setRightEditable(false);
        this.getCompareConfiguration().setProperty("IGNORE_WHITESPACE", (Object)true);
    }

    public R4EUIReviewItem getBaseReviewItem() {
        return this.fBaseReviewItem;
    }

    public R4EUIReviewItem getTargetReviewItem() {
        return this.fTargetReviewItem;
    }

    protected Object prepareInput(IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        R4EDiffNode node;
        if (aMonitor != null) {
            aMonitor.beginTask("R4E Review Item Compare", -1);
        }
        if (this.fRootNode != null) {
            return this.fRootNode;
        }
        this.fRootNode = new DiffNode(0);
        ArrayList<R4EUIFileContext> matchedBasefiles = new ArrayList<R4EUIFileContext>();
        for (R4EUIFileContext targetFile : this.fTargetReviewItem.getFileContexts()) {
            if (targetFile.getFileContext().getTarget() == null) continue;
            node = null;
            boolean identicalFiles = false;
            for (R4EUIFileContext basefile : this.fBaseReviewItem.getFileContexts()) {
                String targetPath = null;
                if (basefile.getFileContext().getTarget() != null) {
                    targetPath = targetFile.getFileContext().getTarget().getRepositoryPath();
                }
                String basePath = null;
                if (basefile.getFileContext().getTarget() != null) {
                    basePath = basefile.getFileContext().getTarget().getRepositoryPath();
                }
                if (targetPath == null || basePath == null || !targetPath.equals(basePath)) continue;
                if (!targetFile.getTargetFileVersion().getVersionID().equals(basefile.getTargetFileVersion().getVersionID())) {
                    node = new R4EDiffNode(targetFile, basefile, true);
                } else {
                    identicalFiles = true;
                }
                matchedBasefiles.add(basefile);
                break;
            }
            if (node == null && !identicalFiles) {
                node = new R4EDiffNode(targetFile, null, true);
            }
            if (node == null) continue;
            DiffNode parent = this.findNode(this.fRootNode, node.getPath());
            parent.add((IDiffElement)node);
        }
        for (R4EUIFileContext basefile : this.fBaseReviewItem.getFileContexts()) {
            if (matchedBasefiles.contains(basefile) || basefile == null || basefile.getFileContext().getTarget() == null) continue;
            node = new R4EDiffNode(null, basefile, true);
            DiffNode parent = this.findNode(this.fRootNode, node.getPath());
            parent.add((IDiffElement)node);
        }
        IDiffElement[] iDiffElementArray = this.fRootNode.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child instanceof R4EDiffNode) {
                this.flattenTree((R4EDiffNode)child);
            }
            ++n2;
        }
        return this.fRootNode;
    }

    private void flattenTree(R4EDiffNode node) {
        this.mergeChild(node);
        IDiffElement[] iDiffElementArray = node.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child instanceof R4EDiffNode) {
                this.flattenTree((R4EDiffNode)child);
            }
            ++n2;
        }
    }

    public void mergeChild(R4EDiffNode node) {
        if (node.getChildren().length == 1 && this.isDirectory(node.getChildren()[0])) {
            R4EDiffNode child = (R4EDiffNode)node.getChildren()[0];
            node.setName(String.valueOf(node.getName()) + "/" + child.getName());
            node.remove((IDiffElement)child);
            IDiffElement[] iDiffElementArray = child.getChildren();
            int n = iDiffElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement element = iDiffElementArray[n2];
                node.add(element);
                ++n2;
            }
            this.mergeChild(node);
        }
    }

    private boolean isDirectory(IDiffElement element) {
        return element instanceof R4EDiffNode && ((R4EDiffNode)element).getTargetFile() == null && ((R4EDiffNode)element).getBaseFile() == null;
    }

    private DiffNode findNode(DiffNode root, IPath path) {
        if (path.segmentCount() == 1) {
            return root;
        }
        String name = path.segment(0);
        IDiffElement child = root.findChild(name);
        if (child instanceof DiffNode) {
            return this.findNode((DiffNode)child, path.removeFirstSegments(1));
        }
        R4EDiffNode node = new R4EDiffNode(name);
        root.add((IDiffElement)node);
        return this.findNode(node, path.removeFirstSegments(1));
    }

    public String getToolTipText() {
        if (this.fTargetReviewItem != null && this.fBaseReviewItem != null) {
            String format = null;
            StringBuilder leftLabel = null;
            String targetItemId = "";
            if (this.fTargetReviewItem != null) {
                targetItemId = this.fTargetReviewItem.getItem().getRepositoryRef();
                leftLabel = targetItemId != null ? new StringBuilder("Target Review Item " + targetItemId) : new StringBuilder("Target Review Item (Current Workspace)");
            }
            StringBuilder rightLabel = null;
            String baseItemId = "";
            if (this.fBaseReviewItem != null) {
                baseItemId = this.fBaseReviewItem.getItem().getRepositoryRef();
                rightLabel = new StringBuilder("Base Review Item " + baseItemId);
            }
            format = CompareUI.getResourceBundle().getString("ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    public Viewer findContentViewer(Viewer aOldViewer, ICompareInput aInput, Composite aParent) {
        Viewer contentViewer = super.findContentViewer(aOldViewer, aInput, aParent);
        if (aInput instanceof R4EDiffNode && !((R4EDiffNode)aInput).getType().equals("FOLDER")) {
            IReviewAnnotationSupport annotationSupport = UIUtils.getCompareAnnotationSupport(contentViewer, ((R4EDiffNode)aInput).getTargetFile(), ((R4EDiffNode)aInput).getBaseFile());
            ((R4EDiffNode)aInput).setAnnotationSupport(annotationSupport);
            UIUtils.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)aParent), annotationSupport);
            this.getCompareConfiguration().setLeftLabel(((R4EDiffNode)aInput).getTargetLabel());
            this.getCompareConfiguration().setRightLabel(((R4EDiffNode)aInput).getBaseLabel());
            this.fCurrentDiffNode = (R4EDiffNode)aInput;
        }
        return contentViewer;
    }

    protected void updateViewerConfig(Viewer aContentViewer, R4EDiffNode aInput) {
        if (aContentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)aContentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("isConfigured");
                declaredField.setAccessible(true);
                declaredField.setBoolean(textMergeViewer, false);
                Method declaredMethod2 = clazz.getDeclaredMethod("updateContent", Object.class, Object.class, Object.class);
                declaredMethod2.setAccessible(true);
                declaredMethod2.invoke((Object)textMergeViewer, null, aInput.getLeft(), aInput.getRight());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

