/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class IO {
    public static String readUTF8(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IO.copy(inputStream, outputStream);
        }
        finally {
            IO.close(inputStream);
        }
        return new String(outputStream.toByteArray(), "UTF-8");
    }

    public static void writeUTF8(File file, String contents) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            IO.copy(inputStream, outputStream);
        }
        finally {
            IO.close(outputStream);
        }
    }

    public static void unzip(InputStream stream, String targetFolder) throws IOException {
        byte[] buffer = new byte[8192];
        ZipInputStream zis = new ZipInputStream(stream);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String name = ze.getName();
            if (!"extractor.exe".equals(name) && !name.endsWith("/")) {
                int len;
                File file = new File(targetFolder, name);
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        long length = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            length += (long)n;
        }
        return length;
    }

    public static long drain(InputStream input) throws IOException {
        long count = 0L;
        while (input.read() != -1) {
            ++count;
        }
        return count;
    }

    public static void close(InputStream closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(OutputStream closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static final class KMPInputStream
    extends InputStream {
        private final InputStream in;
        private final int[] buffer;
        private final byte[] pattern;
        private final int[] failure;
        private int posPattern;
        private int posWrite;
        private int posRead;
        private int filled;
        private int unfilled;
        private boolean eof;

        public KMPInputStream(InputStream in, byte[] pattern) {
            this(in, pattern, KMPInputStream.failureOf(pattern));
        }

        public KMPInputStream(InputStream in, byte[] pattern, int[] failure) {
            this.in = in;
            this.pattern = pattern;
            this.failure = failure;
            this.buffer = new int[8192 + pattern.length];
            this.unfilled = pattern.length;
        }

        public int[] getFailure() {
            return this.failure;
        }

        @Override
        public int read() throws IOException {
            int b;
            while (!this.eof && this.unfilled != 0) {
                b = this.in.read();
                while (this.posPattern > 0 && this.pattern[this.posPattern] != b) {
                    this.posPattern = this.failure[this.posPattern - 1];
                }
                if (this.pattern[this.posPattern] == b) {
                    ++this.posPattern;
                }
                if (this.posPattern == this.pattern.length) {
                    this.eof = true;
                } else {
                    this.buffer[this.posWrite] = b;
                    ++this.posWrite;
                    this.posWrite %= this.buffer.length;
                    ++this.filled;
                }
                --this.unfilled;
            }
            if (this.filled < this.pattern.length) {
                return -1;
            }
            b = this.buffer[this.posRead];
            ++this.posRead;
            this.posRead %= this.buffer.length;
            --this.filled;
            this.unfilled = 1;
            return b;
        }

        /*
         * Unable to fully structure code
         */
        private static int[] failureOf(byte[] pattern) {
            failure = new int[pattern.length];
            j = 0;
            i = 1;
            ** GOTO lbl12
            {
                j = failure[j - 1];
                do {
                    if (j > 0 && pattern[j] != pattern[i]) continue block0;
                    if (pattern[j] == pattern[i]) {
                        // empty if block
                    }
                    failure[i] = ++j;
                    ++i;
lbl12:
                    // 2 sources

                } while (i < pattern.length);
            }
            return failure;
        }
    }
}

