/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;

public class VersionAdvice
extends AbstractAdvice
implements IVersionAdvice {
    Map<String, Map<String, Version>> versions = new HashMap<String, Map<String, Version>>(11);

    public void load(String namespace, String location) {
        this.load(namespace, location, null);
    }

    public void load(String namespace, String location, String idSuffix) {
        Map properties;
        File file = new File(location);
        if (namespace == null) {
            namespace = "null";
        }
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                properties = CollectionUtils.loadProperties((InputStream)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Object key = (String)entry.getKey();
            if (idSuffix != null) {
                key = (String)key + idSuffix;
            }
            this.setVersion(namespace, (String)key, Version.parseVersion((String)((String)entry.getValue())));
        }
    }

    @Override
    public Version getVersion(String namespace, String id) {
        Version result;
        Map<String, Version> values = this.versions.get(namespace);
        if (values != null && (result = values.get(id)) != null) {
            return result;
        }
        values = this.versions.get("null");
        if (values == null) {
            return null;
        }
        return values.get(id);
    }

    public void setVersion(String namespace, String id, Version version) {
        Map<String, Version> values = this.versions.get(namespace);
        if (values == null) {
            if (version == null) {
                return;
            }
            values = new HashMap<String, Version>();
            this.versions.put(namespace, values);
        }
        if (version == null) {
            values.remove(id);
        } else {
            values.put(id, version);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPublisherAdvice merge(IPublisherAdvice advice) {
        void source;
        if (!(advice instanceof VersionAdvice)) {
            return this;
        }
        VersionAdvice versionAdvice = (VersionAdvice)advice;
        for (String namespace : source.versions.keySet()) {
            Map<String, Version> myValues = this.versions.get(namespace);
            Map<String, Version> sourceValues = source.versions.get(namespace);
            if (myValues == null) {
                this.versions.put(namespace, sourceValues);
                continue;
            }
            if (sourceValues == null) continue;
            this.versions.put(namespace, this.merge(myValues, sourceValues));
        }
        return this;
    }

    private Map<String, Version> merge(Map<String, Version> myValues, Map<String, Version> sourceValues) {
        HashMap<String, Version> result = new HashMap<String, Version>(myValues);
        for (String key : sourceValues.keySet()) {
            if (result.get(key) != null) continue;
            result.put(key, sourceValues.get(key));
        }
        return result;
    }
}

