/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutlineNode
implements IOutlineNode,
IOutlineNode.Extension {
    private Image image;
    private ImageDescriptor imageDescriptor;
    private Object text;
    private AbstractOutlineNode parent;
    private List<IOutlineNode> children;
    private boolean isLeaf = false;
    private ITextRegion textRegion;

    protected AbstractOutlineNode(IOutlineNode parent, Image image, Object text, boolean isLeaf) {
        this.text = text == null ? "<unnamed>" : text;
        this.image = image;
        this.isLeaf = isLeaf;
        this.setParent(parent);
        this.textRegion = ITextRegion.EMPTY_REGION;
    }

    protected AbstractOutlineNode(IOutlineNode parent, ImageDescriptor imageDescriptor, Object text, boolean isLeaf) {
        this.text = text == null ? "<unnamed>" : text;
        this.imageDescriptor = imageDescriptor;
        this.isLeaf = isLeaf;
        this.setParent(parent);
        this.textRegion = ITextRegion.EMPTY_REGION;
    }

    protected void setParent(IOutlineNode newParent) {
        Assert.isLegal((newParent == null || newParent instanceof AbstractOutlineNode ? 1 : 0) != 0);
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = (AbstractOutlineNode)newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    protected boolean addChild(IOutlineNode outlineNode) {
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        this.isLeaf = false;
        return this.children.add(outlineNode);
    }

    protected boolean removeChild(IOutlineNode outlineNode) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(outlineNode);
    }

    @Override
    public List<IOutlineNode> getChildren() {
        if (this.isLeaf) {
            return Collections.emptyList();
        }
        if (this.children == null) {
            this.readOnly((IUnitOfWork)new IUnitOfWork.Void<EObject>(){

                public void process(EObject eObject) throws Exception {
                    AbstractOutlineNode.this.getTreeProvider().createChildren(AbstractOutlineNode.this, eObject);
                }
            });
            if (this.children == null) {
                this.isLeaf = true;
                return Collections.emptyList();
            }
        }
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public IOutlineNode getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return !this.isLeaf;
    }

    @Override
    public Object getText() {
        return this.text;
    }

    public void setText(Object text) {
        this.text = text;
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public IXtextDocument getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    public IOutlineTreeStructureProvider getTreeProvider() {
        if (this.parent != null) {
            return this.parent.getTreeProvider();
        }
        return null;
    }

    public void setTextRegion(ITextRegion textRegion) {
        this.textRegion = textRegion;
    }

    @Override
    public ITextRegion getFullTextRegion() {
        return this.textRegion;
    }

    @Override
    public ITextRegion getSignificantTextRegion() {
        return this.textRegion;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.text.toString();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    protected URI getEObjectURI() {
        return null;
    }

    public <T> T readOnly(final IUnitOfWork<T, EObject> work) {
        if (this.getEObjectURI() != null) {
            return (T)this.getDocument().readOnly(new IUnitOfWork<T, XtextResource>(){

                public T exec(XtextResource state) throws Exception {
                    EObject eObject = state.getResourceSet() != null ? state.getResourceSet().getEObject(AbstractOutlineNode.this.getEObjectURI(), true) : state.getEObject(AbstractOutlineNode.this.getEObjectURI().fragment());
                    return work.exec((Object)eObject);
                }
            });
        }
        return null;
    }
}

