/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.draw2d.handles;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

public class ResizeFrameSideHandle
extends AbstractHandle
implements Locator {
    public static final int DEFAULT_SIZE = 4;
    public static final int DEFAULT_INSET = 1;
    private final int mySize;
    private final int myInset;
    private final int myDirection;

    public ResizeFrameSideHandle(IGraphicalEditPart owner, int direction) {
        this(owner, direction, 4, 1);
    }

    public ResizeFrameSideHandle(IGraphicalEditPart owner, int direction, int size, int inset) {
        assert (direction == 1 || direction == 4 || direction == 16 || direction == 8);
        this.setOwner((GraphicalEditPart)owner);
        this.setLocator(this);
        this.mySize = size;
        this.myInset = inset;
        this.myDirection = direction;
        this.setOpaque(false);
        this.setCursor(Cursors.getDirectionalCursor((int)direction));
    }

    protected DragTracker createDragTracker() {
        return new ResizeTracker(this.getOwner(), this.myDirection);
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getCenter();
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    public void relocate(IFigure target) {
        IFigure figure = this.getOwnerFigure();
        Rectangle figureBounds = figure.getBounds();
        figureBounds = new PrecisionRectangle(figureBounds);
        figure.translateToAbsolute((Translatable)figureBounds);
        target.translateToRelative((Translatable)figureBounds);
        Rectangle handleBounds = null;
        switch (this.myDirection) {
            case 8: {
                handleBounds = new Rectangle(figureBounds.x - this.myInset - this.mySize, figureBounds.y - this.myInset, this.mySize, figureBounds.height + this.myInset * 2);
                break;
            }
            case 16: {
                handleBounds = new Rectangle(figureBounds.x + figureBounds.width + this.myInset, figureBounds.y - this.myInset, this.mySize, figureBounds.height + this.myInset * 2);
                break;
            }
            case 1: {
                handleBounds = new Rectangle(figureBounds.x - this.myInset, figureBounds.y - this.myInset - this.mySize, figureBounds.width + this.myInset * 2, this.mySize);
                break;
            }
            case 4: {
                handleBounds = new Rectangle(figureBounds.x - this.myInset, figureBounds.y + figureBounds.height + this.myInset, figureBounds.width + this.myInset * 2, this.mySize);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        target.setBounds(handleBounds);
    }
}

