/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetExpOperations {
    protected LetExpOperations() {
    }

    public static <C, PM> boolean checkLetType(LetExp<C, PM> letExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object inType;
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(letExp, context);
        Object type = letExp.getType();
        OCLExpression<C> in = letExp.getIn();
        if (env != null && type != null && in != null && (inType = in.getType()) != null) {
            result = TypeUtil.exactTypeMatch(env, type, inType);
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 25, OCLMessages.TypeConformanceLetExp_ERROR_, new Object[]{letExp}));
        }
        return result;
    }
}

