/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ocl.expressions.EvaluationVisitor;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;

class IterationTemplate {
    private EvaluationVisitor evalVisitor;
    private EvaluationEnvironment env;
    private boolean done = false;

    protected IterationTemplate(EvaluationVisitor v) {
        this.evalVisitor = v;
        this.env = v.getEvalEnvironment();
    }

    public static IterationTemplate getInstance(EvaluationVisitor v) {
        return new IterationTemplate(v);
    }

    public EvaluationVisitor getEvaluationVisitor() {
        return this.evalVisitor;
    }

    public EvaluationEnvironment getEvalEnvironment() {
        return this.env;
    }

    public final void setDone(boolean done) {
        this.done = done;
    }

    public final boolean isDone() {
        return this.done;
    }

    public Object evaluate(Collection coll, List iterators, OCLExpression body, String resultName) {
        if (coll.isEmpty()) {
            return this.env.getValueOf(resultName);
        }
        int numIters = iterators.size();
        Iterator[] javaIters = new Iterator[numIters];
        this.initializeIterators(iterators, javaIters, coll);
        while (true) {
            Object bodyVal = body.accept(this.evalVisitor);
            Object resultVal = this.evaluateResult(iterators, resultName, bodyVal);
            this.env.replace(resultName, resultVal);
            int curr = this.getNextUnfinishedIterator(javaIters);
            if (!this.moreToGo(curr, numIters)) {
                this.removeIterators(iterators);
                return this.env.getValueOf(resultName);
            }
            this.advanceIterators(iterators, javaIters, coll, curr);
        }
    }

    protected void initializeIterators(List iterators, Iterator[] javaIters, Collection c) {
        int i = 0;
        int n = javaIters.length;
        while (i < n) {
            javaIters[i] = c.iterator();
            Variable iterDecl = (Variable)iterators.get(i);
            String iterName = (String)iterDecl.accept(this.evalVisitor);
            Object value = javaIters[i].next();
            this.env.replace(iterName, value);
            ++i;
        }
    }

    protected int getNextUnfinishedIterator(Iterator[] javaIters) {
        int numIters = javaIters.length;
        int curr = 0;
        while (curr < numIters) {
            if (javaIters[curr].hasNext()) break;
            ++curr;
        }
        return curr;
    }

    protected void advanceIterators(List iterators, Iterator[] javaIters, Collection c, int curr) {
        int i = 0;
        int n = curr;
        while (i <= n) {
            Variable iterDecl = (Variable)iterators.get(i);
            String iterName = iterDecl.getName();
            if (i != curr) {
                javaIters[i] = c.iterator();
            }
            Object value = javaIters[i].next();
            this.env.replace(iterName, value);
            ++i;
        }
    }

    protected void removeIterators(List iterators) {
        int i = 0;
        int n = iterators.size();
        while (i < n) {
            Variable iterDecl = (Variable)iterators.get(i);
            String iterName = iterDecl.getName();
            this.env.remove(iterName);
            ++i;
        }
    }

    protected boolean moreToGo(int curr, int numIters) {
        if (this.done) {
            return false;
        }
        return curr < numIters;
    }

    protected Object evaluateResult(List iterators, String resultName, Object bodyVal) {
        return bodyVal;
    }
}

