/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.CoordinateReferentialUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class UpdateNodeReferenceEditPolicy
extends GraphicalEditPolicy {
    public static String UDPATE_NODE_REFERENCE = "UdpateNodeReferenceEditPolicy";

    public Command getCommand(Request request) {
        if (request instanceof ReconnectRequest && !SenderRequestUtils.isASender(request, (EditPart)this.getHost())) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart linkEditPart = reconnectRequest.getConnectionEditPart();
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE ANCHORS of " + linkEditPart.getClass().getName());
            Point locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential(reconnectRequest.getLocation(), (GraphicalViewer)this.getHost().getViewer());
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+-- LocationOnDiagram " + String.valueOf(locationOnDiagram));
            if (linkEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)linkEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
                CompoundCommand compoundCommand = new CompoundCommand();
                for (Map.Entry<EditPart, String> iterator : references.getStrongReferences().entrySet()) {
                    int delta;
                    EditPart editPart = iterator.getKey();
                    if (SenderRequestUtils.isASender(request, editPart) || !this.getHost().getChildren().contains(editPart)) continue;
                    GraphicalEditPart gEditPart = (GraphicalEditPart)editPart;
                    Point GEPlocationOnDiagram = CoordinateReferentialUtils.getFigurePositionRelativeToDiagramReferential(gEditPart.getFigure(), this.getDiagramEditPart((EditPart)this.getHost()));
                    locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential((Point)SequenceUtil.getSnappedLocation((EditPart)gEditPart, reconnectRequest.getLocation().getCopy()), (GraphicalViewer)this.getHost().getViewer());
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move  from " + String.valueOf(GEPlocationOnDiagram) + " " + editPart.getClass().getName());
                    ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"resize");
                    changeBoundsRequest.setLocation(reconnectRequest.getLocation().getCopy());
                    changeBoundsRequest.setEditParts(editPart);
                    if (iterator.getValue().equals("START")) {
                        delta = locationOnDiagram.y() - GEPlocationOnDiagram.y();
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> Delta " + delta + " " + editPart.getClass().getName());
                        changeBoundsRequest.setMoveDelta(new Point(0, delta));
                        changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                    }
                    if (iterator.getValue().equals("FINISH")) {
                        delta = locationOnDiagram.y() - GEPlocationOnDiagram.y() - gEditPart.getFigure().getBounds().height;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> Delta " + delta + " " + editPart.getClass().getName());
                        changeBoundsRequest.setMoveDelta(new Point(0, delta));
                        changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                    }
                    ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                    SenderRequestUtils.addRequestSenders((Request)changeBoundsRequest, senderList);
                    SenderRequestUtils.addRequestSender((Request)changeBoundsRequest, (EditPart)linkEditPart);
                    Command cmd = editPart.getCommand((Request)changeBoundsRequest);
                    compoundCommand.add(cmd);
                }
                if (!compoundCommand.isEmpty()) {
                    return compoundCommand;
                }
            }
        } else if (request instanceof ChangeBoundsRequest && !"autosize".equals(request.getType())) {
            ChangeBoundsRequest initialChangeBoundsRequest = (ChangeBoundsRequest)request;
            if (initialChangeBoundsRequest.getEditParts() == null || initialChangeBoundsRequest.getEditParts().isEmpty()) {
                return UnexecutableCommand.INSTANCE;
            }
            for (Object childEP : initialChangeBoundsRequest.getEditParts()) {
                LifelineEditPart parentLifeLine;
                if (!(childEP instanceof AbstractExecutionSpecificationEditPart) || !(this.getHost() instanceof CLifeLineEditPart) || (parentLifeLine = SequenceUtil.getParentLifelinePart((EditPart)((AbstractExecutionSpecificationEditPart)((Object)childEP)))) == null || ((Object)((Object)parentLifeLine)).equals(this.getHost())) continue;
                return UnexecutableCommand.INSTANCE;
            }
            Point moveDelta = initialChangeBoundsRequest.getMoveDelta();
            CompoundCommand compoundCommand = new CompoundCommand();
            if (moveDelta.y != 0) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE delta " + String.valueOf(moveDelta) + " of " + String.valueOf(this.getHost()));
                int maxY = -1;
                AbstractExecutionSpecificationEditPart editPartSaved = null;
                for (Object changedEditPart : initialChangeBoundsRequest.getEditParts()) {
                    Bounds initialBoundStrongRef;
                    AbstractExecutionSpecificationEditPart execSpecEditPart;
                    if (!(changedEditPart instanceof AbstractExecutionSpecificationEditPart)) continue;
                    editPartSaved = execSpecEditPart = (AbstractExecutionSpecificationEditPart)((Object)changedEditPart);
                    if (((EditPart)changedEditPart).getEditPolicy((Object)"SEQUENCE_REFERENCE") != null && !SenderRequestUtils.isASender(request, (EditPart)execSpecEditPart)) {
                        SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)execSpecEditPart.getEditPolicy("SEQUENCE_REFERENCE");
                        for (EditPart editPart : references.getStrongReferences().keySet()) {
                            if (SenderRequestUtils.isASender(request, editPart) || !(editPart instanceof GraphicalEditPart) || !(editPart.getModel() instanceof Node)) continue;
                            Bounds initialBoundStrongRef2 = BoundForEditPart.getBounds((Node)editPart.getModel());
                            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + editPart.getClass().getName());
                            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move from " + initialBoundStrongRef2.getY() + " " + editPart.getClass().getName());
                            ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"resize");
                            changeBoundsRequest.setLocation(new Point(initialBoundStrongRef2.getX(), initialBoundStrongRef2.getY()));
                            changeBoundsRequest.setEditParts(editPart);
                            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> Delta " + moveDelta.y + " " + editPart.getClass().getName());
                            changeBoundsRequest.setMoveDelta(new Point(0, moveDelta.y));
                            changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                            ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                            SenderRequestUtils.addRequestSenders((Request)changeBoundsRequest, senderList);
                            SenderRequestUtils.addRequestSender((Request)changeBoundsRequest, (EditPart)execSpecEditPart);
                            Command cmd = editPart.getCommand((Request)changeBoundsRequest);
                            compoundCommand.add(cmd);
                            if (moveDelta.y <= 0 || maxY >= initialBoundStrongRef2.getY() + initialBoundStrongRef2.getHeight() + changeBoundsRequest.getMoveDelta().y + 15) continue;
                            maxY = initialBoundStrongRef2.getY() + initialBoundStrongRef2.getHeight() + changeBoundsRequest.getMoveDelta().y + 15;
                        }
                    }
                    if (moveDelta.y <= 0 || maxY >= (initialBoundStrongRef = BoundForEditPart.getBounds((Node)execSpecEditPart.getModel())).getY() + initialBoundStrongRef.getHeight() + moveDelta.y + 15) continue;
                    maxY = initialBoundStrongRef.getY() + initialBoundStrongRef.getHeight() + moveDelta.y + 15;
                }
                if (editPartSaved != null && maxY > 0) {
                    CompoundCommand resizeCompoundCommand = new CompoundCommand("Resize life lines");
                    LifelineEditPartUtil.resizeAllLifeLines(resizeCompoundCommand, (EditPart)editPartSaved, maxY, null);
                    if (!resizeCompoundCommand.isEmpty()) {
                        compoundCommand.add((Command)resizeCompoundCommand);
                    }
                }
            }
            if (!compoundCommand.isEmpty()) {
                return compoundCommand;
            }
        }
        return super.getCommand(request);
    }

    public DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof DiagramEditPart) {
                return (DiagramEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        if (editPart instanceof DiagramRootEditPart) {
            return (DiagramEditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
        }
        return null;
    }
}

