/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.util;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;

public class HyperLinkHelpersRegistrationUtil {
    public static final String HYPERLINK_REGISTRATION_ID = "org.eclipse.papyrus.infra.hyperlink.registration";
    public static final String HELPER = "helper";
    public static final String TAB_ID = "tabId";
    public static final String POSITION = "position";
    private Map<Integer, AbstractHyperLinkHelper> map = null;
    public static final HyperLinkHelpersRegistrationUtil INSTANCE = new HyperLinkHelpersRegistrationUtil();

    private HyperLinkHelpersRegistrationUtil() {
    }

    public Collection<AbstractHyperLinkHelper> getAllRegisteredHyperLinkHelper() {
        if (this.map == null) {
            this.getHelperWithPosition();
        }
        return this.map.values();
    }

    public Map<Integer, AbstractHyperLinkHelper> getHelperWithPosition() {
        if (this.map == null) {
            IConfigurationElement[] config;
            this.map = new TreeMap<Integer, AbstractHyperLinkHelper>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(HYPERLINK_REGISTRATION_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                AbstractHyperLinkHelper helper = null;
                try {
                    Object h = e.createExecutableExtension(HELPER);
                    if (h instanceof AbstractHyperLinkHelper) {
                        helper = (AbstractHyperLinkHelper)h;
                        String o = e.getAttribute(POSITION);
                        Integer order = Integer.valueOf(o);
                        String tabId = e.getAttribute(TAB_ID);
                        helper.setTabId(tabId);
                        this.map.put(order, helper);
                    } else {
                        Activator.log.info(NLS.bind((String)Messages.HyperLinkTabRegistrationUtil_NotAnInstanceOf, (Object[])new Object[]{h, AbstractHyperLinkHelper.class}));
                    }
                }
                catch (NumberFormatException exception) {
                    Activator.log.error(NLS.bind((String)Messages.HyperLinkHelpersRegistrationUtil_TheHelperWillBeIgnored, helper), (Throwable)exception);
                }
                catch (CoreException ex) {
                    Activator.log.error(Messages.HyperLinkHelpersRegistrationUtil_ICantCreateTheClassForAnHelper, (Throwable)ex);
                }
                ++n2;
            }
        }
        return this.map;
    }
}

