/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.IconAndMessagePapyrusPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.MessagePapyrusPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.popups.PopupNotification;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PopupBuilder
implements IBuilder {
    @Override
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        MessagePapyrusPopup popup = null;
        String title = "Papyrus";
        if (wrapper.getTitle() != null) {
            title = wrapper.getTitle();
        }
        String message = null;
        if (wrapper.getMessage() != null) {
            message = wrapper.getMessage();
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        if (wrapper.getType() != null) {
            popup = new IconAndMessagePapyrusPopup(activeShell, toolkit, message, wrapper.getType());
        } else if (wrapper.getImage() != null) {
            popup = new IconAndMessagePapyrusPopup(activeShell, toolkit, message);
            ((IconAndMessagePapyrusPopup)popup).setImage(wrapper.getImage());
        } else {
            popup = new MessagePapyrusPopup(activeShell, toolkit, message);
        }
        popup.setTitle(title);
        popup.setUseHtml(wrapper.isHtml());
        if (wrapper.getComposite() != null) {
            popup.setCompositeCreator(wrapper.getComposite());
            popup.setTitle(title);
        }
        if (wrapper.getActions() != null) {
            popup.addRunnables(wrapper.getActions());
        }
        PopupNotification result = new PopupNotification(popup);
        popup.setINotification(result);
        result.setResult(popup.open());
        return result;
    }

    @Override
    public boolean accept(String parameterName, Object value) {
        if ("asynchronous".equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        if ("delay".equals(parameterName)) {
            return false;
        }
        if ("title".equals(parameterName)) {
            return true;
        }
        if ("type".equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.IMAGE.equals(parameterName)) {
            return true;
        }
        if ("message".equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.COMPOSITE.equals(parameterName)) {
            return true;
        }
        if ("html".equals(parameterName)) {
            return true;
        }
        if ("default_action".equals(parameterName)) {
            return true;
        }
        if ("temporary".equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        return false;
    }
}

