/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.decorator;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.papyrus.infra.gmfdiag.navigation.decorator.NavigationDecorator;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;

public class NavigationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static Set<Class<?>> forbiddenClasses;
    private static Set<Class<?>> decoratedClasses;
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.navigation.navigationDecoratorRules";
    private static final String FORBIDDENCLASS_ID = "forbiddenClass";
    private static final String DECORATEDCLASS_ID = "decoratedClass";
    private static final String CLASS_ID = "class";

    static {
        IConfigurationElement[] configElements;
        forbiddenClasses = new HashSet();
        decoratedClasses = new HashSet();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String className = configElement.getAttribute(CLASS_ID);
            Class class_ = null;
            try {
                class_ = Platform.getBundle((String)configElement.getContributor().getName()).loadClass(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (class_ != null) {
                if (FORBIDDENCLASS_ID.equals(configElement.getName())) {
                    forbiddenClasses.add(class_);
                } else if (DECORATEDCLASS_ID.equals(configElement.getName())) {
                    decoratedClasses.add(class_);
                }
            }
            ++n2;
        }
    }

    public boolean provides(IOperation operation) {
        IDecoratorTarget decoratorTarget;
        EditPart editPart;
        String decoratorVisibility = Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DECORATOR_VISIBILITY");
        if (operation instanceof CreateDecoratorsOperation && !"DISABLED".equals(decoratorVisibility) && (editPart = (EditPart)(decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget()).getAdapter(EditPart.class)) instanceof IPrimaryEditPart) {
            EObject element = ((IGraphicalEditPart)editPart).resolveSemanticElement();
            boolean decorate = false;
            for (Class<?> class_ : decoratedClasses) {
                if (!class_.isInstance(element)) continue;
                decorate = true;
                break;
            }
            for (Class<?> class_ : forbiddenClasses) {
                if (!class_.isInstance(element)) continue;
                decorate = false;
                break;
            }
            return decorate;
        }
        return false;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        new NavigationDecorator(decoratorTarget);
    }
}

