/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.base.Defaults;
import com.google.common.base.Supplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AnnotationRule<T>
implements TestRule,
Supplier<T> {
    private final Class<? extends Annotation> annotationType;
    private final Method valueAccessor;
    private T value;

    private AnnotationRule(Class<? extends Annotation> annotationType, Method accessor, T default_) {
        this.annotationType = annotationType;
        this.valueAccessor = accessor;
        this.value = default_;
    }

    public static <T> AnnotationRule<T> create(Class<? extends Annotation> annotationType, T default_) {
        try {
            Method method = annotationType.getDeclaredMethod("value", new Class[0]);
            Class<?> resultType = method.getReturnType();
            if (default_ == null && resultType != Class.class) {
                default_ = Defaults.defaultValue(resultType);
            }
            return new AnnotationRule<T>(annotationType, method, default_);
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot get annotation value: " + e.getMessage()));
            throw new Error();
        }
    }

    public static <T> AnnotationRule<T> create(Class<? extends Annotation> annotationType) {
        return AnnotationRule.create(annotationType, null);
    }

    public static AnnotationRule<Boolean> createExists(Class<? extends Annotation> annotationType) {
        return new AnnotationRule<Boolean>(annotationType, null, false);
    }

    public final T get() {
        return this.value;
    }

    public Statement apply(final Statement base, Description description) {
        Statement result = base;
        final Annotation annotation = JUnitUtils.getAnnotation(description, this.annotationType);
        if (annotation != null) {
            result = new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        if (AnnotationRule.this.valueAccessor == null) {
                            AnnotationRule.this.value = Boolean.TRUE;
                        } else {
                            Object extracted = AnnotationRule.this.valueAccessor.invoke((Object)annotation, new Object[0]);
                            if (extracted instanceof Class) {
                                extracted = ((Class)extracted).newInstance();
                            }
                            AnnotationRule.this.value = extracted;
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Cannot get annotation value: " + e.getMessage()));
                    }
                    try {
                        base.evaluate();
                    }
                    finally {
                        if (AnnotationRule.this.valueAccessor != null) {
                            AnnotationRule.this.value = Defaults.defaultValue(AnnotationRule.this.valueAccessor.getReturnType());
                        }
                    }
                }
            };
        }
        return result;
    }
}

