/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class PapyrusProjectUtils {
    private PapyrusProjectUtils() {
    }

    public static final IFile copyPapyrusModel(IProject project, Bundle bundle, String sourcePath, String fileRootName) throws CoreException, IOException {
        String diSourcePath = String.valueOf(sourcePath) + fileRootName + "." + "di";
        String notationSourcePath = String.valueOf(sourcePath) + fileRootName + "." + "notation";
        String umlSourcePath = String.valueOf(sourcePath) + fileRootName + "." + "uml";
        IFile emptyModel_di = PapyrusProjectUtils.copyIFile(diSourcePath, bundle, project, String.valueOf(fileRootName) + "." + "di");
        PapyrusProjectUtils.copyIFile(notationSourcePath, bundle, project, String.valueOf(fileRootName) + "." + "notation");
        PapyrusProjectUtils.copyIFile(umlSourcePath, bundle, project, String.valueOf(fileRootName) + "." + "uml");
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String propertiesSourcePath = String.valueOf(sourcePath) + fileRootName + "_" + locale.toString() + "." + "properties";
            URL bundleResource = bundle.getResource(propertiesSourcePath);
            if (bundleResource != null) {
                PapyrusProjectUtils.copyIFile(propertiesSourcePath, bundle, project, String.valueOf(fileRootName) + "_" + locale.toString() + "." + "properties");
            }
            ++n2;
        }
        return emptyModel_di;
    }

    public static IFile copyIFile(String sourcePath, Bundle sourceBundle, IProject targetProject, String targetFileName) throws CoreException, IOException {
        IFile createdFile = targetProject.getFile(targetFileName);
        if (createdFile.getParent() instanceof IFolder) {
            PapyrusProjectUtils.createRecursiveFolder((IFolder)createdFile.getParent());
        }
        URL bundleResource = sourceBundle.getResource(sourcePath);
        Assert.assertNotNull((String)("Cannot find bundle resource: " + sourcePath), (Object)bundleResource);
        InputStream bundleResourceStream = bundleResource.openStream();
        createdFile.create(bundleResourceStream, true, (IProgressMonitor)new NullProgressMonitor());
        return createdFile;
    }

    public static void createRecursiveFolder(IFolder folderToCreate) throws CoreException {
        if (folderToCreate.exists()) {
            return;
        }
        if (folderToCreate.getParent() instanceof IFolder) {
            PapyrusProjectUtils.createRecursiveFolder((IFolder)folderToCreate.getParent());
        }
        folderToCreate.create(true, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

