/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import org.eclipse.papyrus.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandAnalyzable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandEvaluatable;

public abstract class Statement
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    public Statement(int start, int end, int line) {
        super(start, end, line);
    }

    @Override
    public final void evaluate(ExecutionContext ctx) {
        try {
            this.notifyEnter(ctx);
            ctx.getScope().getOutput().enterStatement(this);
            this.evaluateInternal(ctx);
            ctx.getScope().getOutput().exitStatement(null);
        }
        finally {
            this.notifyLeave(ctx);
        }
    }

    protected abstract void evaluateInternal(ExecutionContext var1);

    private void notifyEnter(ExecutionContext ctx) {
        EvaluationListener l = ctx.getScope().getEvaluationListener();
        if (l != null) {
            l.enter(this, ctx);
        }
    }

    private void notifyLeave(ExecutionContext ctx) {
        EvaluationListener l = ctx.getScope().getEvaluationListener();
        if (l != null) {
            l.leave(this, ctx);
        }
    }
}

