/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.papyrus.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.papyrus.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.Variable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.DeclaredParameter;

public class Advice
extends AbstractDefinition
implements XpandAdvice {
    public static final String DEF_VAR_NAME = "targetDef";
    private final Identifier pointCut;
    private final boolean wildParams;
    private Pattern p = null;

    public Advice(int start, int end, int line, Identifier pointCut, TypeCS type, DeclaredParameter[] params, boolean wildParams, Statement[] body) {
        super(start, end, line, type, params, body);
        this.pointCut = pointCut;
        this.wildParams = wildParams;
    }

    public Identifier getPointCut() {
        return this.pointCut;
    }

    public String toString() {
        return String.valueOf(this.owner.getFullyQualifiedName()) + " " + this.pointCut.getValue() + this.getParamString() + " FOR " + this.type.toString();
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithVariable(new Variable(DEF_VAR_NAME, (EClassifier)BuiltinMetaModel.DEFINITION_TYPE, null));
        super.analyze(ctx, issues);
    }

    private String getParamString() {
        if (this.params == null || this.params.length == 0) {
            return this.wildParams ? "(*)" : "";
        }
        StringBuilder buff = new StringBuilder("(");
        int i = 0;
        while (i < this.params.length) {
            DeclaredParameter p = this.params[i];
            buff.append(p.getVarName()).append(" ").append(p.getTypeName());
            if (i + 1 < this.params.length) {
                buff.append(",");
            }
            ++i;
        }
        if (this.wildParams) {
            buff.append(",*");
        }
        return buff.append(")").toString();
    }

    @Override
    public boolean matches(XpandDefinition def, ExecutionContext ctx) {
        if (this.p == null) {
            this.p = Pattern.compile(this.pointCut.getValue().replaceAll("\\*", ".*"));
        }
        Matcher m1 = this.p.matcher(def.getName());
        Matcher m2 = this.p.matcher(String.valueOf(def.getOwner().getFullyQualifiedName()) + "::" + def.getName());
        if (m1.matches() || m2.matches()) {
            EClassifier at;
            ctx = ctx.cloneWithResource(def.getOwner());
            EClassifier t = def.getTargetType().getTypeForName(ctx);
            EClassifier[] paramTypes = new EClassifier[def.getParams().length];
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = def.getParams()[i].getTypeForName(ctx);
                ++i;
            }
            if ((this.params.length == paramTypes.length || this.wildParams && this.params.length <= paramTypes.length) && BuiltinMetaModel.isAssignableFrom(ctx = ctx.cloneWithResource(this.owner), at = this.type.getTypeForName(ctx), t)) {
                int i2 = 0;
                while (i2 < this.params.length) {
                    EClassifier pt = this.params[i2].getTypeForName(ctx);
                    if (!BuiltinMetaModel.isAssignableFrom(ctx, pt, paramTypes[i2])) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }
}

