/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.wizards.pages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.gmf.internal.bridge.ui.Plugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShowDashboardPage
extends WizardPage {
    private boolean showDashboard;
    private Button showDashboardCheckbox;

    public ShowDashboardPage(String pageId, boolean showDashboard) {
        super(pageId);
        this.showDashboard = showDashboard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)this.createFillData());
        this.showDashboardCheckbox = new Button(composite, 32);
        this.showDashboardCheckbox.setText(Plugin.getBundleString("showDashboardPage.text"));
        this.showDashboardCheckbox.setLayoutData((Object)this.createHrzData());
        this.showDashboardCheckbox.setSelection(this.showDashboard);
        this.showDashboardCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowDashboardPage.this.showDashboard = ShowDashboardPage.this.showDashboardCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite filler = new Composite(composite, 0);
        filler.setLayoutData((Object)this.createFillData());
        this.setControl((Control)this.showDashboardCheckbox);
    }

    protected GridData createHrzData() {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    protected GridData createFillData() {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    public boolean isShowDashboard() {
        return this.showDashboard;
    }

    public void setShowDashboard(boolean showDashboard) {
        this.showDashboard = showDashboard;
        if (this.showDashboardCheckbox != null && !this.showDashboardCheckbox.isDisposed()) {
            this.showDashboardCheckbox.setSelection(showDashboard);
        }
    }
}

