/**
 * Copyright (c) 2007, 2014 Borland Software Corporation, CEA, and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - refactored javaInitilizers not to use methods from GMFGen model
 *                               [221347] Got rid of generated interfaces
 *                               (IObjectInitializer, IFeatureInitializer) and implementation thereof
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Christian W. Damus (CEA) - bug 440263
 */
package aspects.xpt.providers;

import aspects.xpt.Common;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenReferenceNewElementSpec;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.expressions.AbstractExpression;
import xpt.providers.ElementInitializers_qvto;

/**
 * XXX should generate this class only when there is initialization logic defined in the model
 */
@Singleton
@SuppressWarnings("all")
public class ElementInitializers extends xpt.providers.ElementInitializers {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ElementInitializers_qvto _elementInitializers_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private AbstractExpression xptAbstractExpression;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Override
  protected CharSequence _javaMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _javaMethod = this.javaMethod(it.getModelFacet(), it);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  protected CharSequence _javaMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _javaMethod = this.javaMethod(it.getModelFacet(), it);
        _builder.append(_javaMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  protected CharSequence _performInit(final GenFeatureValueSpec it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenLanguage _language = it.getValue().getProvider().getLanguage();
      boolean _equals = Objects.equal(_language, GenLanguage.LITERAL_LITERAL);
      if (_equals) {
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getFeature(), instanceVar, instanceClass, it.getValue().getBody());
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      } else {
        String expressionVarName = this._elementInitializers_qvto.getVariableName("value", counters);
        _builder.newLineIfNotEmpty();
        _builder.append("Object ");
        _builder.append(expressionVarName);
        _builder.append(" = ");
        CharSequence _evaluateExpr = this.evaluateExpr(it.getValue().getProvider(), diagramElement, it, instanceVar);
        _builder.append(_evaluateExpr);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        {
          boolean _isListType = it.getFeature().isListType();
          if (_isListType) {
            _builder.append("if (");
            _builder.append(expressionVarName);
            _builder.append(" instanceof java.util.Collection) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
            _builder.append(_featureValue, "    ");
            _builder.append(".clear();");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast) {
                _builder.append("    ");
                _builder.append("for (java.util.Iterator it = ((java.util.Collection) ");
                _builder.append(expressionVarName, "    ");
                _builder.append(").iterator(); it.hasNext(); ) {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("Object next = ");
                CharSequence _qualifiedClassName = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName, "        ");
                _builder.append(".performCast(it.next(), ");
                CharSequence _MetaClass = this.xptMetaModel.MetaClass(it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass, "        ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                CharSequence _featureValue_1 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
                _builder.append(_featureValue_1, "        ");
                _builder.append(".add((");
                CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getFeature().getTypeGenClassifier());
                _builder.append(_QualifiedClassName, "        ");
                _builder.append(") next);");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("    ");
                CharSequence _featureValue_2 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
                _builder.append(_featureValue_2, "    ");
                _builder.append(".addAll(((java.util.Collection) ");
                _builder.append(expressionVarName, "    ");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("} else if(");
            _builder.append(expressionVarName);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast_1 = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast_1) {
                _builder.append("    ");
                _builder.append(expressionVarName, "    ");
                _builder.append(" = ");
                CharSequence _qualifiedClassName_1 = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName_1, "    ");
                _builder.append(".performCast(");
                _builder.append(expressionVarName, "    ");
                _builder.append(", ");
                CharSequence _MetaClass_1 = this.xptMetaModel.MetaClass(
                  it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass_1, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("    ");
            CharSequence _featureValue_3 = this.xptMetaModel.getFeatureValue(it.getFeature(), instanceVar, instanceClass, true);
            _builder.append(_featureValue_3, "    ");
            _builder.append(".add((");
            CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getFeature().getTypeGenClassifier());
            _builder.append(_QualifiedClassName_1, "    ");
            _builder.append(") ");
            _builder.append(expressionVarName, "    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          } else {
            _builder.append("if(");
            _builder.append(expressionVarName);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _expressionResultNeedsCast_2 = this._elementInitializers_qvto.expressionResultNeedsCast(it.getFeature().getTypeGenClassifier());
              if (_expressionResultNeedsCast_2) {
                _builder.append("    ");
                CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
                _builder.append(_extraLineBreak_1, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append(expressionVarName, "    ");
                _builder.append(" = ");
                CharSequence _qualifiedClassName_2 = this.xptAbstractExpression.qualifiedClassName(diagramElement.getDiagram());
                _builder.append(_qualifiedClassName_2, "    ");
                _builder.append(".performCast(");
                _builder.append(expressionVarName, "    ");
                _builder.append(", ");
                CharSequence _MetaClass_2 = this.xptMetaModel.MetaClass(
                  it.getFeature().getTypeGenClassifier());
                _builder.append(_MetaClass_2, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("        ");
            CharSequence _setFeatureValue = this.xptMetaModel.setFeatureValue(it.getFeature(), instanceVar, instanceClass, expressionVarName, true);
            _builder.append(_setFeatureValue, "        ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  @Override
  protected CharSequence _initMethod(final GenFeatureSeqInitializer it, final GenCommonBase diagramElement) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init_");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(diagramElement);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getElementClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" instance) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    {
      EList<GenFeatureInitializer> _initializers = it.getInitializers();
      for(final GenFeatureInitializer i : _initializers) {
        _builder.append("\t\t");
        CharSequence _performInit = this.performInit(i, diagramElement, "instance", it.getElementClass(), CollectionLiterals.<Integer>newLinkedList(Integer.valueOf(it.getInitializers().indexOf(i))));
        _builder.append(_performInit, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("} catch(RuntimeException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(diagramElement.getDiagram().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().logError(\"Element initialization failed\", e); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence initMethodCall(final GenCommonBase linkOrNode, final TypeModelFacet modelFacet, final String newElementVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenElementInitializer _modelElementInitializer = modelFacet.getModelElementInitializer();
      boolean _notEquals = (!Objects.equal(_modelElementInitializer, null));
      if (_notEquals) {
        CharSequence _elementInitializersInstanceCall = this.elementInitializersInstanceCall(linkOrNode);
        _builder.append(_elementInitializersInstanceCall);
        _builder.append(".init_");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(linkOrNode);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("(");
        _builder.append(newElementVar);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence javaMethod(final GenLinkEnd it) {
    if (it instanceof GenNode) {
      return _javaMethod((GenNode)it);
    } else if (it instanceof GenLink) {
      return _javaMethod((GenLink)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  @Override
  public CharSequence performInit(final GenFeatureInitializer it, final GenCommonBase diagramElement, final String instanceVar, final GenClass instanceClass, final List<Integer> counters) {
    if (it instanceof GenFeatureValueSpec) {
      return _performInit((GenFeatureValueSpec)it, diagramElement, instanceVar, instanceClass, counters);
    } else if (it instanceof GenReferenceNewElementSpec) {
      return _performInit((GenReferenceNewElementSpec)it, diagramElement, instanceVar, instanceClass, counters);
    } else if (it != null) {
      return _performInit(it, diagramElement, instanceVar, instanceClass, counters);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, instanceVar, instanceClass, counters).toString());
    }
  }
  
  @Override
  public CharSequence initMethod(final EObject it, final GenCommonBase diagramElement) {
    if (it instanceof GenFeatureSeqInitializer) {
      return _initMethod((GenFeatureSeqInitializer)it, diagramElement);
    } else if (it instanceof TypeModelFacet) {
      return _initMethod((TypeModelFacet)it, diagramElement);
    } else if (it instanceof GenElementInitializer) {
      return _initMethod((GenElementInitializer)it, diagramElement);
    } else if (it instanceof ModelFacet) {
      return _initMethod((ModelFacet)it, diagramElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement).toString());
    }
  }
}
