/**
 * Copyright (c) 2007, 2010 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.diagram.commands;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.OclMigrationProblems_qvto;
import xpt.diagram.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class CreateNodeCommand extends xpt.diagram.commands.CreateNodeCommand {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private OclMigrationProblems_qvto _oclMigrationProblems_qvto;
  
  @Inject
  @Extension
  private MetaModel _metaModel;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Override
  public CharSequence CreateNodeCommand(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      boolean _isPhantomElement = it.getModelFacet().isPhantomElement();
      boolean _not = (!_isPhantomElement);
      if (_not) {
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.runtime.notation.Diagram diagram = null;");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence __constructor = this._constructor(it);
    _builder.append(__constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _elementToEdit = this.getElementToEdit(it);
    _builder.append(_elementToEdit, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _canExecuteMethod = this.canExecuteMethod(it);
    _builder.append(_canExecuteMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doExecuteWithResultMethod = this.doExecuteWithResultMethod(it);
    _builder.append(_doExecuteWithResultMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doConfigureMethod = this.doConfigureMethod(it);
    _builder.append(_doConfigureMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence _constructor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req, org.eclipse.gmf.runtime.notation.Diagram diagram) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(req.getLabel(), null, req);");
    _builder.newLine();
    {
      boolean _isPhantomElement = it.getModelFacet().isPhantomElement();
      boolean _not = (!_isPhantomElement);
      if (_not) {
        _builder.append("\t");
        _builder.append("this.diagram = diagram;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence doExecuteWithResultMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append(" \t\t\t\t");
    _builder.newLine();
    {
      boolean _isAbstract = it.getModelFacet().getMetaClass().getEcoreClass().isAbstract();
      boolean _notEquals = (_isAbstract != true);
      if (_notEquals) {
        {
          boolean _isPhantomElement = it.getModelFacet().isPhantomElement();
          if (_isPhantomElement) {
            CharSequence _phantomElementCreation = this.phantomElementCreation(it.getModelFacet(), it, "newElement");
            _builder.append(_phantomElementCreation);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _normalElementCreation = this.normalElementCreation(it.getModelFacet(), it, "newElement");
            _builder.append(_normalElementCreation);
            _builder.newLineIfNotEmpty();
          }
        }
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
        CharSequence _initialize = this.initialize(it.getModelFacet(), it, "newElement");
        _builder.append(_initialize);
        _builder.newLineIfNotEmpty();
        {
          if (true) {
            CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
            _builder.append(_extraLineBreak_1);
            _builder.newLineIfNotEmpty();
            _builder.append("doConfigure(newElement, monitor, info);");
            _builder.newLine();
            CharSequence _extraLineBreak_2 = this._common.extraLineBreak();
            _builder.append(_extraLineBreak_2);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).setNewElement(");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getModelFacet().getMetaClass(), "newElement");
        _builder.append(_DowncastToEObject, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(newElement);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("throw new UnsupportedOperationException(\"Unimplemented operation (abstract domain element).\");");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence canExecute_Normal(final TypeModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
      boolean _notEquals = (!Objects.equal(_containmentMetaFeature, null));
      if (_notEquals) {
        {
          EStructuralFeature _ecoreFeature = it.getContainmentMetaFeature().getEcoreFeature();
          boolean _notEquals_1 = (!Objects.equal(_ecoreFeature, null));
          if (_notEquals_1) {
            {
              if (((!this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature())) || ((!Objects.equal(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature()))))) {
                {
                  boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature());
                  boolean _not = (!_isUnbounded);
                  if (_not) {
                    CharSequence _DeclareAndAssign = this._metaModel.DeclareAndAssign(it.getContainmentMetaFeature().getGenClass(), "container", "getElementToEdit()");
                    _builder.append(_DeclareAndAssign);
                    _builder.newLineIfNotEmpty();
                    {
                      boolean _isSingleValued = this._oclMigrationProblems_qvto.isSingleValued(it.getContainmentMetaFeature().getEcoreFeature());
                      if (_isSingleValued) {
                        _builder.append("\t\t");
                        _builder.append("if (");
                        CharSequence _featureValue = this._metaModel.getFeatureValue(it.getContainmentMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                        _builder.append(_featureValue, "\t\t");
                        _builder.append(" != null) {");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t\t");
                        _builder.append("if (");
                        CharSequence _featureValue_1 = this._metaModel.getFeatureValue(it.getContainmentMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                        _builder.append(_featureValue_1, "\t\t");
                        _builder.append(".size() >= ");
                        int _upperBound = it.getContainmentMetaFeature().getEcoreFeature().getUpperBound();
                        _builder.append(_upperBound, "\t\t");
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t\t");
                    _builder.append("return false;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
                {
                  if (((!Objects.equal(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature())))) {
                    {
                      boolean _isSingleValued_1 = this._oclMigrationProblems_qvto.isSingleValued(it.getChildMetaFeature().getEcoreFeature());
                      if (_isSingleValued_1) {
                        _builder.append("\t\t");
                        _builder.append("if (");
                        CharSequence _featureValue_2 = this._metaModel.getFeatureValue(it.getChildMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                        _builder.append(_featureValue_2, "\t\t");
                        _builder.append(" != null) {");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t\t");
                        _builder.append("if (");
                        CharSequence _featureValue_3 = this._metaModel.getFeatureValue(it.getChildMetaFeature(), "container", it.getContainmentMetaFeature().getGenClass());
                        _builder.append(_featureValue_3, "\t\t");
                        _builder.append(".size() >= ");
                        int _upperBound_1 = it.getChildMetaFeature().getEcoreFeature().getUpperBound();
                        _builder.append(_upperBound_1, "\t\t");
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("\t\t");
                    _builder.append("return false;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("org.eclipse.emf.ecore.EObject target = getElementToEdit();");
    _builder.newLine();
    _builder.append("org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData data = org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker.getFor(target).getChildAddData(diagram, target.eClass(), ");
    CharSequence _MetaClass = this._metaModel.MetaClass(it.getMetaClass());
    _builder.append(_MetaClass);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("return data.isPermitted();");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence normalElementCreation(final TypeModelFacet it, final GenNode node, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _NewInstance = this.xptMetaModel.NewInstance(it.getMetaClass(), varName);
    _builder.append(_NewInstance);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("org.eclipse.emf.ecore.EObject target = getElementToEdit();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData data = org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker.getFor(target).getChildAddData(diagram, target, ");
    _builder.append(varName, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (data.isPermitted()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (data.isPathDefined()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (!data.execute(target, ");
    _builder.append(varName, "\t\t\t\t");
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newErrorCommandResult(\"Failed to follow the policy-specified for the insertion of the new element\");");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    {
      GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
      boolean _notEquals = (!Objects.equal(_containmentMetaFeature, null));
      if (_notEquals) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getContainmentMetaFeature().getGenClass(), "qualifiedTarget", "target");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getContainmentMetaFeature(), "qualifiedTarget", it.getContainmentMetaFeature().getGenClass(), varName);
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("//");
        _builder.newLine();
        _builder.append("// FIXME no containment feature found in the genmodel, toolsmith need to manually write code here to add ");
        _builder.append(varName);
        _builder.append(" to a parent");
        _builder.newLineIfNotEmpty();
        _builder.append("//");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newErrorCommandResult(\"The active policy restricts the addition of this element\");");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _hasExplicitChildFeature = this._utils_qvto.hasExplicitChildFeature(it);
      if (_hasExplicitChildFeature) {
        CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getChildMetaFeature().getGenClass(), "childHolder", "getElementToEdit()");
        _builder.append(_DeclareAndAssign_1);
        _builder.newLineIfNotEmpty();
        CharSequence _modifyFeature_1 = this.xptMetaModel.modifyFeature(it.getChildMetaFeature(), "childHolder", it.getChildMetaFeature().getGenClass(), varName);
        _builder.append(_modifyFeature_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
