/**
 * Copyright (c) 2017 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 * Nicolas FAUVERGUE (ALL4TEC) nicolas.fauvergue@all4tec.net - Bug 496905
 * Gabriel Pascual (ALL4TEC) gabriel.pascual@all4tec.net - Bug 464625
 */
package aspects.parsers;

import com.google.inject.Singleton;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class PredefinedParser extends parsers.PredefinedParser {
  @Override
  public CharSequence extendsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.common.parsers.AbstractElementTypeBasedAttributeParser");
    return _builder;
  }
  
  @Override
  public CharSequence additions(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* {@inheritDoc}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @see org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractFeatureParser#getModificationCommand(org.eclipse.emf.ecore.EObject, org.eclipse.emf.ecore.EStructuralFeature, java.lang.Object)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.ICommand getModificationCommand(final org.eclipse.emf.ecore.EObject element, final org.eclipse.emf.ecore.EStructuralFeature feature, final Object value) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand result = null;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// If the feature to edit is the name, check that this is not really the internationalization to edit and not the name");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (feature.equals(org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getNamedElement_Name())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils.getInternationalizationPreference(element) && null != org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement) element)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final org.eclipse.papyrus.infra.core.resource.ModelSet modelSet = (org.eclipse.papyrus.infra.core.resource.ModelSet) element.eResource().getResourceSet();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (null != modelSet) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("result = new org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand(modelSet.getTransactionalEditingDomain(), (org.eclipse.uml2.uml.NamedElement) element, (String) value, null));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null != result ? result : super.getModificationCommand(element, feature, value);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* {@inheritDoc}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @see org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractAttributeParser#getValue(org.eclipse.emf.ecore.EObject, org.eclipse.emf.ecore.EStructuralFeature)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected Object getValue(final org.eclipse.emf.ecore.EObject element, final org.eclipse.emf.ecore.EStructuralFeature feature) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object result = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(element instanceof org.eclipse.uml2.uml.NamedElement && feature.equals(org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getNamedElement_Name())){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils.getInternationalizationPreference(element) && null != org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement)element)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result = UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement)element);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null != result ? result : super.getValue(element, feature);");
    _builder.newLine();
    _builder.append("}\t");
    _builder.newLine();
    return _builder;
  }
}
