/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.IModelVisitor;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.LifeStatusKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MemberKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StateKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class PropertyModel {
    protected MemberKind memberKind = MemberKind.owned;
    protected StateKind stateKind = StateKind.loaded;
    protected LifeStatusKind lifeStatusKind = LifeStatusKind.running;
    protected Property property;
    protected String proposedName;
    protected Type type;
    protected String value = "defaultValue";
    protected Object initialValue;
    protected Object objectValue;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public PropertyModel(MemberKind modelStatusKind) {
        this.memberKind = modelStatusKind;
    }

    public PropertyModel(MemberKind modelStatusKind, Property property) {
        this.memberKind = modelStatusKind;
        this.stateKind = StateKind.loaded;
        this.property = property;
        if (property != null) {
            this.proposedName = property.getName();
        }
    }

    public PropertyModel(MemberKind modelStatusKind, Property property, Object propertyValue) {
        this.memberKind = modelStatusKind;
        this.stateKind = StateKind.loaded;
        this.property = property;
        if (property != null) {
            this.proposedName = property.getName();
            this.type = property.getType();
        }
        if (propertyValue != null) {
            this.initialValue = propertyValue;
            this.objectValue = propertyValue;
            this.value = propertyValue.toString();
        }
    }

    public PropertyModel(MemberKind modelStatusKind, String proposedName) {
        this.memberKind = modelStatusKind;
        this.stateKind = StateKind.created;
        this.proposedName = proposedName;
    }

    public PropertyModel(MemberKind modelStatusKind, String proposedName, Type type) {
        this.memberKind = modelStatusKind;
        this.stateKind = StateKind.created;
        this.proposedName = proposedName;
        this.type = type;
    }

    public MemberKind getMemberKind() {
        return this.memberKind;
    }

    public String getProposedName() {
        return this.proposedName;
    }

    public void setProposedName(String proposedName) {
        this.proposedName = proposedName;
        this.firePropertyChange("proposedName", this.proposedName, this.proposedName);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.firePropertyChange("type", this.type, this.type);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.firePropertyChange("value", this.value, this.value);
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.changeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public StateKind getStateKind() {
        return this.stateKind;
    }

    public void setStateKind(StateKind stateKind) {
        this.stateKind = stateKind;
        this.firePropertyChange("stateKind", (Object)this.stateKind, (Object)this.stateKind);
    }

    public LifeStatusKind getLifeStatusKind() {
        return this.lifeStatusKind;
    }

    public void setLifeStatusKind(LifeStatusKind lifeStatusKind) {
        this.lifeStatusKind = lifeStatusKind;
        this.firePropertyChange("lifeStatusKind", (Object)this.lifeStatusKind, (Object)this.lifeStatusKind);
    }

    public void modelChangedEvent() {
        switch (this.stateKind) {
            case loaded: {
                this.stateKind = StateKind.modified;
                break;
            }
        }
    }

    public void deleteModelEvent() {
        switch (this.lifeStatusKind) {
            case running: {
                this.setLifeStatusKind(LifeStatusKind.deleted);
                break;
            }
            case deleted: {
                this.setLifeStatusKind(LifeStatusKind.running);
                break;
            }
        }
    }

    public boolean isPropertyExistIn(Stereotype stereotype) {
        if (this.proposedName == null) {
            return false;
        }
        return stereotype.getAttribute(this.proposedName, null) != null;
    }

    public boolean isValueModified() {
        if (this.initialValue == null || this.getValue() == null) {
            return this.initialValue != null || this.getValue() != null;
        }
        String originalValue = this.initialValue.toString();
        return !this.getValue().equals(originalValue);
    }
}

