/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.IdentityAnchorHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GrillingEditpart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.NoGrillElementFound;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;

public class ConnectMessageToGridEditPolicy
extends GraphicalEditPolicyEx
implements AutomaticNotationEditPolicy,
NotificationListener,
IGrillingEditpolicy {
    protected GrillingEditpart gridCompartment = null;
    public static String CONNECT_TO_GRID_MANAGEMENT = "CONNECT_TO_GRID_MANAGEMENT";
    protected int displayImprecision = 2;
    private View rowSource;
    private View rowTarget;

    protected void updatePositionGridAxis(DecorationNode axis, int x, int y) {
        Location currentBounds = (Location)axis.getLayoutConstraint();
        if (x < currentBounds.getX() - this.displayImprecision || x > currentBounds.getX() + this.displayImprecision) {
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS to x=" + x + " y=" + y);
            this.execute((ICommand)new SetLocationCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update Column", (IAdaptable)new EObjectAdapter((EObject)axis), new Point(x, y)));
        }
        if (y < currentBounds.getY() - this.displayImprecision || y > currentBounds.getY() + this.displayImprecision) {
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS to x=" + x + " y=" + y);
            this.execute((ICommand)new SetLocationCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update row", (IAdaptable)new EObjectAdapter((EObject)axis), new Point(x, y)));
        }
    }

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            if (grilling != null) {
                ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
                Edge edge = (Edge)connectionEditPart.getModel();
                IdentityAnchor sourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
                IdentityAnchor targetAnchor = (IdentityAnchor)edge.getTargetAnchor();
                GraphicalEditPart sourceEditPart = (GraphicalEditPart)connectionEditPart.getSource();
                GraphicalEditPart targetEditPart = (GraphicalEditPart)connectionEditPart.getTarget();
                if (sourceAnchor != null && targetAnchor != null) {
                    double absoluteY;
                    Message m;
                    if (sourceAnchor.getId() != null && !sourceAnchor.getId().equals("")) {
                        int targetAnchorY;
                        m = (Message)connectionEditPart.resolveSemanticElement();
                        absoluteY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor, sourceEditPart);
                        if (targetEditPart != null && (double)(targetAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor, targetEditPart)) <= absoluteY) {
                            absoluteY = targetAnchorY - 1;
                        }
                        this.rowSource = m.getSendEvent() == null ? grilling.createRowTolisten((int)absoluteY, (Element)m) : grilling.createRowTolisten((int)absoluteY, (Element)m.getSendEvent());
                        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowSource, (NotificationListener)this);
                    }
                    if (targetEditPart != null && targetAnchor.getId() != null && !targetAnchor.getId().equals("")) {
                        int sourceAnchorY;
                        m = (Message)connectionEditPart.resolveSemanticElement();
                        absoluteY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor, targetEditPart);
                        if (sourceEditPart != null && (double)(sourceAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor, sourceEditPart)) >= absoluteY) {
                            absoluteY = sourceAnchorY + 1;
                        }
                        this.rowTarget = m.getReceiveEvent() == null ? grilling.createRowTolisten((int)absoluteY, (Element)m) : grilling.createRowTolisten((int)absoluteY, (Element)m.getReceiveEvent());
                        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowTarget, (NotificationListener)this);
                    }
                }
            }
        }
        catch (NoGrillElementFound e) {
            UMLDiagramEditorPlugin.log.error((Throwable)e);
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        if (diagramEditPart != null) {
            EditPart sourceEditpart;
            IdentityAnchor sourceAnchor;
            EditPart targetEditpart;
            IdentityAnchor targetAnchor;
            IdentityAnchor sourceAnchor2;
            Edge edge;
            ConnectionEditPart connectionEditPart;
            int targetAnchorY;
            GraphicalEditPart targetEditpart2;
            Edge edge2;
            int sourceAnchorY;
            GraphicalEditPart sourceEditpart2;
            ConnectionEditPart connectionEditPart2;
            if (notification.getNotifier().equals(this.getHost().getModel()) && NotationPackage.eINSTANCE.getEdge_SourceAnchor().equals(notification.getFeature()) && notification.getNewValue() != null) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT :CREATION add SourceAnchor " + notification.getNotifier());
                IdentityAnchor sourceAnchor3 = (IdentityAnchor)notification.getNewValue();
                if (sourceAnchor3.getId() != null && !sourceAnchor3.getId().equals("")) {
                    connectionEditPart2 = (ConnectionEditPart)this.getHost();
                    Message m = (Message)connectionEditPart2.resolveSemanticElement();
                    if (connectionEditPart2.getSource() instanceof GraphicalEditPart) {
                        int targetAnchorY2;
                        sourceEditpart2 = (GraphicalEditPart)connectionEditPart2.getSource();
                        sourceAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor3, sourceEditpart2);
                        edge2 = (Edge)connectionEditPart2.getNotationView();
                        IdentityAnchor targetAnchor2 = (IdentityAnchor)edge2.getTargetAnchor();
                        EditPart targetEditpart3 = connectionEditPart2.getTarget();
                        if (targetEditpart3 instanceof GraphicalEditPart && targetAnchor2 != null && (targetAnchorY2 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor2, (GraphicalEditPart)targetEditpart3)) <= sourceAnchorY) {
                            sourceAnchorY = targetAnchorY2 - 1;
                        }
                        try {
                            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                            if (grilling != null) {
                                if (this.rowSource == null) {
                                    this.rowSource = m.getSendEvent() == null ? grilling.createRowTolisten(sourceAnchorY, (Element)m) : grilling.createRowTolisten(sourceAnchorY, (Element)m.getSendEvent());
                                }
                                this.getDiagramEventBroker().addNotificationListener((EObject)this.rowSource, (NotificationListener)this);
                            }
                        }
                        catch (NoGrillElementFound e) {
                            UMLDiagramEditorPlugin.log.error((Throwable)e);
                        }
                    }
                }
            }
            if (notification.getNotifier().equals(this.getHost().getModel()) && NotationPackage.eINSTANCE.getEdge_TargetAnchor().equals(notification.getFeature()) && notification.getNewValue() != null) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: CREATION add targetAnchor " + notification.getNotifier());
                IdentityAnchor targetAnchor3 = (IdentityAnchor)notification.getNewValue();
                if (targetAnchor3.getId() != null && !targetAnchor3.getId().equals("") && (connectionEditPart2 = (ConnectionEditPart)this.getHost()).getTarget() instanceof GraphicalEditPart) {
                    int sourceAnchorY2;
                    targetEditpart2 = (GraphicalEditPart)connectionEditPart2.getTarget();
                    Message m = (Message)connectionEditPart2.resolveSemanticElement();
                    targetAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor3, targetEditpart2);
                    edge2 = (Edge)connectionEditPart2.getNotationView();
                    IdentityAnchor sourceAnchor4 = (IdentityAnchor)edge2.getSourceAnchor();
                    EditPart sourceEditpart3 = connectionEditPart2.getSource();
                    if (sourceEditpart3 instanceof GraphicalEditPart && sourceAnchor4 != null && targetAnchorY <= (sourceAnchorY2 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor4, (GraphicalEditPart)sourceEditpart3))) {
                        targetAnchorY = sourceAnchorY2 + 1;
                    }
                    try {
                        GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                        if (grilling != null) {
                            if (this.rowTarget == null) {
                                this.rowTarget = m.getReceiveEvent() == null ? grilling.createRowTolisten(targetAnchorY, (Element)m) : grilling.createRowTolisten(targetAnchorY, (Element)m.getReceiveEvent());
                            }
                            this.getDiagramEventBroker().addNotificationListener((EObject)this.rowTarget, (NotificationListener)this);
                        }
                    }
                    catch (NoGrillElementFound e) {
                        UMLDiagramEditorPlugin.log.error((Throwable)e);
                    }
                }
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getEdge_Source())) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT Source change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge = (Edge)connectionEditPart.getNotationView();
                if (edge.getSourceAnchor() != null && this.rowSource != null) {
                    sourceAnchor2 = (IdentityAnchor)edge.getSourceAnchor();
                    if (connectionEditPart.getSource() instanceof GraphicalEditPart) {
                        int targetAnchorY3;
                        sourceEditpart2 = (GraphicalEditPart)connectionEditPart.getSource();
                        sourceAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor2, sourceEditpart2);
                        targetAnchor = (IdentityAnchor)edge.getTargetAnchor();
                        targetEditpart = connectionEditPart.getTarget();
                        if (targetEditpart instanceof GraphicalEditPart && targetAnchor != null && (targetAnchorY3 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor, (GraphicalEditPart)targetEditpart)) <= sourceAnchorY) {
                            sourceAnchorY = targetAnchorY3 - 1;
                        }
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + sourceAnchorY + " ");
                        this.updatePositionGridAxis((DecorationNode)this.rowSource, 0, sourceAnchorY);
                    }
                }
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getEdge_Target())) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT target change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge = (Edge)connectionEditPart.getNotationView();
                if (edge.getTargetAnchor() != null && this.rowTarget != null) {
                    IdentityAnchor targetAnchor4 = (IdentityAnchor)edge.getTargetAnchor();
                    if (connectionEditPart.getTarget() instanceof GraphicalEditPart) {
                        int sourceAnchorY3;
                        GraphicalEditPart targetEditpart4 = (GraphicalEditPart)connectionEditPart.getTarget();
                        targetAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor4, targetEditpart4);
                        sourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
                        sourceEditpart = connectionEditPart.getSource();
                        if (sourceEditpart instanceof GraphicalEditPart && sourceAnchor != null && targetAnchorY <= (sourceAnchorY3 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor, (GraphicalEditPart)sourceEditpart))) {
                            targetAnchorY = sourceAnchorY3 + 1;
                        }
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + targetAnchorY + " ");
                        this.updatePositionGridAxis((DecorationNode)this.rowTarget, 0, targetAnchorY);
                    }
                }
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof IdentityAnchor) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT IdentificationAnchor change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge = (Edge)connectionEditPart.getNotationView();
                if (notification.getNotifier().equals(edge.getSourceAnchor()) && this.rowSource != null) {
                    sourceAnchor2 = (IdentityAnchor)edge.getSourceAnchor();
                    if (connectionEditPart.getSource() instanceof GraphicalEditPart) {
                        int targetAnchorY4;
                        sourceEditpart2 = (GraphicalEditPart)connectionEditPart.getSource();
                        sourceAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor2, sourceEditpart2);
                        targetAnchor = (IdentityAnchor)edge.getTargetAnchor();
                        targetEditpart = connectionEditPart.getTarget();
                        if (targetEditpart instanceof GraphicalEditPart && targetAnchor != null && (targetAnchorY4 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor, (GraphicalEditPart)targetEditpart)) <= sourceAnchorY) {
                            sourceAnchorY = targetAnchorY4 - 1;
                        }
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + sourceAnchorY + " ");
                        this.updatePositionGridAxis((DecorationNode)this.rowSource, 0, sourceAnchorY);
                    }
                }
                if (notification.getNotifier().equals(edge.getTargetAnchor()) && this.rowTarget != null && connectionEditPart.getTarget() instanceof GraphicalEditPart) {
                    int sourceAnchorY4;
                    targetEditpart2 = (GraphicalEditPart)connectionEditPart.getTarget();
                    IdentityAnchor targetAnchor5 = (IdentityAnchor)edge.getTargetAnchor();
                    targetAnchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(targetAnchor5, targetEditpart2);
                    sourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
                    sourceEditpart = connectionEditPart.getSource();
                    if (sourceEditpart instanceof GraphicalEditPart && sourceAnchor != null && targetAnchorY <= (sourceAnchorY4 = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(sourceAnchor, (GraphicalEditPart)sourceEditpart))) {
                        targetAnchorY = sourceAnchorY4 + 1;
                    }
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+-->TARGET change " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + targetAnchorY + " ");
                    this.updatePositionGridAxis((DecorationNode)this.rowTarget, 0, targetAnchorY);
                }
            }
        }
    }

    public static int computeAnchorPositionNotation(IdentityAnchor anchor, GraphicalEditPart nodeEditPart) {
        double yPercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)anchor);
        Node node = (Node)nodeEditPart.getNotationView();
        PrecisionRectangle bounds = NotationHelper.getAbsoluteBounds((Node)node);
        double height = BoundForEditPart.getHeightFromView(node);
        int anchorY = (int)(height * yPercent) + bounds.y;
        return anchorY;
    }
}

