/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IDetailLabelProvider;
import org.eclipse.swt.graphics.Image;

public class StandardEMFLabelProvider
extends AdapterFactoryLabelProvider
implements IDetailLabelProvider {
    private static Map<String, AdapterFactory> factories = new HashMap<String, AdapterFactory>();
    private static final String EXT_FACTORIES = "org.eclipse.emf.edit.itemProviderAdapterFactories";
    private static final String I_ITEM_LABEL_PROVIDER = "org.eclipse.emf.edit.provider.IItemLabelProvider";

    public StandardEMFLabelProvider() {
        super((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public String getText(Object element) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null) {
            return this.getText(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getText((IStructuredSelection)element);
        }
        return super.getText(element);
    }

    protected String getText(EObject element) {
        String title = "";
        if (element instanceof Enumerator) {
            return ((Enumerator)element).getLiteral() == null || ((Enumerator)element).getLiteral().isEmpty() ? ((Enumerator)element).getName() : ((Enumerator)element).getLiteral();
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        IItemLabelProvider itemLabelProvider = this.getItemLabelProvider(eObject);
        if (itemLabelProvider != null) {
            title = itemLabelProvider.getText((Object)eObject);
        }
        if ("".equals(title)) {
            title = super.getText((Object)eObject);
        }
        return title;
    }

    protected String getText(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return "";
        }
        Object element = selection.getFirstElement();
        return this.getText(element);
    }

    public Image getImage(Object element) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null) {
            return this.getImage(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getImage((IStructuredSelection)element);
        }
        return super.getImage(element);
    }

    protected Image getImage(EObject eObject) {
        Image result = null;
        IItemLabelProvider itemLabelProvider = this.getItemLabelProvider(eObject);
        if (itemLabelProvider != null) {
            result = this.getImageFromObject(itemLabelProvider.getImage((Object)eObject));
        }
        return result;
    }

    protected Image getImage(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Object element = selection.getFirstElement();
        return this.getImage(element);
    }

    private IItemLabelProvider getItemLabelProvider(EObject eObject) {
        AdapterFactory adapterFactory;
        IItemLabelProvider itemLabelProvider = null;
        if (eObject != null && (adapterFactory = StandardEMFLabelProvider.getEditFactory(eObject)) != null) {
            itemLabelProvider = this.adapt(adapterFactory, eObject);
        }
        return itemLabelProvider;
    }

    IItemLabelProvider adapt(AdapterFactory adapterFactory, EObject object) {
        return (IItemLabelProvider)adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
    }

    public static AdapterFactory getEditFactory(EObject eobject) {
        String uri = eobject.eClass().getEPackage().getNsURI();
        return StandardEMFLabelProvider.getFactory(uri);
    }

    public static AdapterFactory getFactory(String uri) {
        AdapterFactory factory = factories.get(uri);
        if (factory == null) {
            IConfigurationElement[] extensions;
            IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_FACTORIES);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String types;
                List<String> typesList;
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (uri.equals(e.getAttribute("uri")) && (typesList = Arrays.asList((types = e.getAttribute("supportedTypes")).split("\\s+"))).contains(I_ITEM_LABEL_PROVIDER)) {
                    try {
                        factory = (AdapterFactory)e.createExecutableExtension("class");
                        if (factory != null) {
                            factories.put(uri, factory);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return factory;
    }

    public String getDetail(Object object) {
        object = EMFHelper.getEObject((Object)object);
        return String.valueOf(this.getText(object)) + " - " + this.getQualifiedClassName(object);
    }

    protected String getQualifiedClassName(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            return EMFHelper.getQualifiedName((EClassifier)eClass, (String)"::");
        }
        return "";
    }
}

