/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.ElementTypesPluginChecker;
import org.osgi.service.component.annotations.Component;

@Component
public class ElementTypesBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return "elementtypesconfigurations".equals(resourceURI.fileExtension());
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.elementtypes.diagnostic", this::mapElementTypesResources);
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = result.withChecker(ElementTypesPluginChecker.modelValidationCheckerFactory()).withChecker(ElementTypesPluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = result.withChecker(ElementTypesPluginChecker.modelDependenciesCheckerFactory()).withChecker(ElementTypesPluginChecker.buildPropertiesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = result.withChecker(ElementTypesPluginChecker.extensionsCheckerFactory());
            }
        }
        return result;
    }

    private ListMultimap<IFile, ElementTypeSetConfiguration> mapElementTypesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"elementtypesconfigurations"), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(ElementTypeSetConfiguration.class));
    }
}

