/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_technicalpolicies;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TechnicalAspectConstraint implements Enumerator
{
    ANY_NUMBER(0, "ANY_NUMBER", "ANY_NUMBER"),
    AT_MOST_ONE(1, "AT_MOST_ONE", "AT_MOST_ONE"),
    EXACTLY_ONE(2, "EXACTLY_ONE", "EXACTLY_ONE"),
    AT_LEAST_ONE(3, "AT_LEAST_ONE", "AT_LEAST_ONE");

    public static final int ANY_NUMBER_VALUE = 0;
    public static final int AT_MOST_ONE_VALUE = 1;
    public static final int EXACTLY_ONE_VALUE = 2;
    public static final int AT_LEAST_ONE_VALUE = 3;
    private static final TechnicalAspectConstraint[] VALUES_ARRAY;
    public static final List<TechnicalAspectConstraint> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TechnicalAspectConstraint[]{ANY_NUMBER, AT_MOST_ONE, EXACTLY_ONE, AT_LEAST_ONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TechnicalAspectConstraint get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TechnicalAspectConstraint result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TechnicalAspectConstraint getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TechnicalAspectConstraint result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TechnicalAspectConstraint get(int value) {
        switch (value) {
            case 0: {
                return ANY_NUMBER;
            }
            case 1: {
                return AT_MOST_ONE;
            }
            case 2: {
                return EXACTLY_ONE;
            }
            case 3: {
                return AT_LEAST_ONE;
            }
        }
        return null;
    }

    private TechnicalAspectConstraint(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

