/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.xtext.base.serializer.DataTypeRuleValue;
import org.eclipse.ocl.xtext.base.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.xtext.base.serializer.DynamicRuleMatch;
import org.eclipse.ocl.xtext.base.serializer.EClassValue;
import org.eclipse.ocl.xtext.base.serializer.EnumerationValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarCardinality;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleVector;
import org.eclipse.ocl.xtext.base.serializer.ParserRuleValue;
import org.eclipse.ocl.xtext.base.serializer.SerializationMatchStep;
import org.eclipse.ocl.xtext.base.serializer.SerializationMatchTerm;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationRule;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.SerializationStep;
import org.eclipse.ocl.xtext.base.serializer.SerializationUtils;
import org.eclipse.ocl.xtext.base.serializer.SubstringStep;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;

public abstract class AbstractSerializationMetaData
implements SerializationMetaData {
    private @NonNull Grammar grammar;
    private @Nullable Map<@NonNull EReference, @NonNull Map<@NonNull String, @NonNull CrossReference>> eReference2ruleName2crossReference = null;
    private @Nullable Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2innerFormattingSegments;
    private @Nullable Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2outerFormattingSegments;

    protected AbstractSerializationMetaData(@NonNull Grammar grammar) {
        this.grammar = grammar;
    }

    private void analyzeGrammar(@NonNull Grammar grammar, @NonNull Map<@NonNull EReference, @NonNull Map<@NonNull String, @NonNull CrossReference>> eReference2ruleName2crossReference) {
        for (EObject eObject : new TreeIterable((EObject)grammar, false)) {
            CrossReference oldCrossReference;
            if (!(eObject instanceof CrossReference)) continue;
            CrossReference crossReference = (CrossReference)eObject;
            EReference eReference = GrammarUtil.getReference((CrossReference)crossReference);
            assert (eReference != null);
            RuleCall ruleCall = (RuleCall)crossReference.getTerminal();
            AbstractRule calledRule = ruleCall.getRule();
            String calledRuleName = calledRule.getName();
            assert (calledRuleName != null);
            Map<@NonNull String, @NonNull CrossReference> ruleName2crossReference = eReference2ruleName2crossReference.get(eReference);
            if (ruleName2crossReference == null) {
                ruleName2crossReference = new HashMap<String, CrossReference>();
                eReference2ruleName2crossReference.put(eReference, ruleName2crossReference);
            }
            if ((oldCrossReference = ruleName2crossReference.get(calledRuleName)) != null) continue;
            ruleName2crossReference.put(calledRuleName, crossReference);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            assert (usedGrammar != null);
            this.analyzeGrammar(usedGrammar, eReference2ruleName2crossReference);
        }
    }

    @Override
    public @Nullable EClassValue basicGetEClassValue(@NonNull EClass eClass) {
        @NonNull EClassValue[] eClassValues = this.getEClassValues();
        int loIndex = 0;
        int hiIndex = eClassValues.length;
        while (loIndex < hiIndex) {
            int tryIndex = loIndex + hiIndex - 1 >>> 1;
            EClassValue eClassValue = eClassValues[tryIndex];
            int comparison = NameUtil.ENAMED_ELEMENT_COMPARATOR.compare((ENamedElement)eClassValue.getEClass(), (ENamedElement)eClass);
            if (comparison < 0) {
                loIndex = tryIndex + 1;
                continue;
            }
            if (comparison > 0) {
                hiIndex = tryIndex;
                continue;
            }
            return eClassValue;
        }
        return null;
    }

    @Override
    public @Nullable GrammarRuleValue basicGetGrammarRuleValue(@NonNull String ruleName) {
        @NonNull GrammarRuleValue[] grammarRuleValues = this.getGrammarRuleValues();
        int loIndex = 0;
        int hiIndex = grammarRuleValues.length;
        while (loIndex < hiIndex) {
            int tryIndex = loIndex + hiIndex - 1 >>> 1;
            GrammarRuleValue grammarRuleValue = grammarRuleValues[tryIndex];
            int comparison = grammarRuleValue.getRuleName().compareTo(ruleName);
            if (comparison < 0) {
                loIndex = tryIndex + 1;
                continue;
            }
            if (comparison > 0) {
                hiIndex = tryIndex;
                continue;
            }
            return grammarRuleValue;
        }
        return null;
    }

    @Override
    public @Nullable SerializationStep basicGetGlobalSerializationStepAssignment(@NonNull EStructuralFeature eStructuralFeature) {
        @NonNull SerializationStep[] serializationSteps = this.getSerializationSteps();
        int loIndex = this.getFirstGlobalSerializationStepAssignmentIndex();
        int hiIndex = this.getLastGlobalSerializationStepAssignmentIndex() + 1;
        while (loIndex < hiIndex) {
            int tryIndex = loIndex + hiIndex - 1 >>> 1;
            SerializationStep.SerializationStepAbstractFeature serializationStep = (SerializationStep.SerializationStepAbstractFeature)serializationSteps[tryIndex];
            int comparison = NameUtil.ENAMED_ELEMENT_COMPARATOR.compare((ENamedElement)serializationStep.getEStructuralFeature(), (ENamedElement)eStructuralFeature);
            if (comparison < 0) {
                loIndex = tryIndex + 1;
                continue;
            }
            if (comparison > 0) {
                hiIndex = tryIndex;
                continue;
            }
            return serializationStep;
        }
        return null;
    }

    @Override
    public @Nullable SerializationStep.SerializationStepKeyword basicGetGlobalSerializationStepKeyword(@NonNull String keyword) {
        @NonNull SerializationStep[] serializationSteps = this.getSerializationSteps();
        int loIndex = this.getFirstGlobalSerializationStepLiteralIndex();
        int hiIndex = this.getLastGlobalSerializationStepLiteralIndex() + 1;
        while (loIndex < hiIndex) {
            int tryIndex = loIndex + hiIndex - 1 >>> 1;
            SerializationStep.SerializationStepKeyword serializationStep = (SerializationStep.SerializationStepKeyword)serializationSteps[tryIndex];
            int comparison = serializationStep.getKeyword().compareTo(keyword);
            if (comparison < 0) {
                loIndex = tryIndex + 1;
                continue;
            }
            if (comparison > 0) {
                hiIndex = tryIndex;
                continue;
            }
            return serializationStep;
        }
        return null;
    }

    protected @NonNull GrammarRuleValue createDataTypeRuleValue(int ruleIndex, @NonNull String name, int serializationSegmentsIndex, int ... subStringStepIndexes) {
        SubstringStep[] substringSteps;
        @NonNull SerializationSegment @NonNull [] @NonNull [] serializationSegments = this.getSerializationSegments();
        SerializationSegment[] ruleSerializationSegments = serializationSegments[serializationSegmentsIndex];
        int iMax = subStringStepIndexes.length;
        if (iMax > 0) {
            substringSteps = new SubstringStep[iMax];
            @NonNull SubstringStep @NonNull [] allSubstringSteps = this.getSubstringSteps();
            int i = 0;
            int[] nArray = subStringStepIndexes;
            int n = subStringStepIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int subStringStepIndex = nArray[n2];
                substringSteps[i++] = allSubstringSteps[subStringStepIndex];
                ++n2;
            }
        } else {
            substringSteps = null;
        }
        return new DataTypeRuleValue(ruleIndex, name, ruleSerializationSegments, substringSteps);
    }

    protected @NonNull EClassValue.EReference_TargetGrammarRuleVector createEReference_TargetGrammarRuleVector(EReference eReference, int targetGrammarRuleVectorIndex) {
        return new EClassValue.EReference_TargetGrammarRuleVector(eReference, this.getGrammarRuleVectors()[targetGrammarRuleVectorIndex]);
    }

    protected @NonNull SerializationMatchStep createMatchStep_Assert(int serializationMatchTermIndex) {
        return new SerializationMatchStep.MatchStep_Assert(this.getSerializationMatchTerms()[serializationMatchTermIndex]);
    }

    protected @NonNull SerializationMatchStep createMatchStep_Assign(int cardinalityVariableIndex, int serializationMatchTermIndex) {
        return new SerializationMatchStep.MatchStep_Assign(cardinalityVariableIndex, this.getSerializationMatchTerms()[serializationMatchTermIndex]);
    }

    protected @NonNull SerializationMatchStep createMatchStep_RuleCheck(EReference eReference, int grammarRuleValueIndexes) {
        return new SerializationMatchStep.MatchStep_RuleCheck(eReference, this.getGrammarRuleVectors()[grammarRuleValueIndexes]);
    }

    protected @NonNull SerializationMatchStep createMatchStep_Runtime() {
        return new SerializationMatchStep.MatchStep_Runtime();
    }

    protected @NonNull SerializationMatchStep createMatchStep_ValueCheck(int cardinalityVariableIndex, int serializationMatchTermIndex) {
        return new SerializationMatchStep.MatchStep_ValueCheck(cardinalityVariableIndex, this.getSerializationMatchTerms()[serializationMatchTermIndex]);
    }

    protected @NonNull GrammarRuleValue createParserRuleValue(int ruleIndex, @NonNull String name, int subParserRuleValueIndexes, @NonNull SerializationRule @NonNull [] serializationRules, int ... serializationSegmentsBiIndexes) {
        @NonNull SerializationSegment @NonNull [] @NonNull [] serializationSegments = this.getSerializationSegments();
        int iMax = serializationSegmentsBiIndexes.length;
        @NonNull SerializationSegment @NonNull [] @NonNull [] innerSerializationSegmentsArray = new SerializationSegment[iMax][];
        @NonNull SerializationSegment @NonNull [] @NonNull [] outerSerializationSegmentsArray = new SerializationSegment[iMax][];
        int i = 0;
        while (i < iMax) {
            int serializationSegmentsBiIndex = serializationSegmentsBiIndexes[i];
            int innerSerializationSegmentsIndex = serializationSegmentsBiIndex & 0xFFFF;
            int outerSerializationSegmentsIndex = serializationSegmentsBiIndex >> 16 & 0xFFFF;
            innerSerializationSegmentsArray[i] = serializationSegments[innerSerializationSegmentsIndex];
            outerSerializationSegmentsArray[i] = serializationSegments[outerSerializationSegmentsIndex];
            ++i;
        }
        return new ParserRuleValue(ruleIndex, name, serializationRules, outerSerializationSegmentsArray, innerSerializationSegmentsArray, subParserRuleValueIndexes >= 0 ? this.getGrammarRuleVectors()[subParserRuleValueIndexes] : null);
    }

    protected @NonNull SerializationRule.SerializationAttribute createSerializationEnumeratedAttribute(EAttribute eAttribute, boolean needsDefault, int ... enumerationValue_grammarCardinalities) {
        assert (eAttribute != null);
        int iMax = enumerationValue_grammarCardinalities.length;
        @NonNull EnumerationValue[] enumerationValues = new EnumerationValue[iMax];
        @NonNull GrammarCardinality[] grammarCardinalities = new GrammarCardinality[iMax];
        int i = 0;
        while (i < iMax) {
            EnumerationValue enumerationValue = this.getEnumerationValues()[enumerationValue_grammarCardinalities[i] >> 4];
            GrammarCardinality grammarCardinality = GrammarCardinality.valueOf(enumerationValue_grammarCardinalities[i] & 0xF);
            assert (enumerationValue != null);
            enumerationValues[i] = enumerationValue;
            grammarCardinalities[i] = grammarCardinality;
            ++i;
        }
        return new SerializationRule.SerializationEnumeratedAttribute(eAttribute, needsDefault, enumerationValues, grammarCardinalities);
    }

    protected @NonNull SerializationMatchStep @NonNull [] createSerializationMatchSteps(int ... serializationMatchStepIndexes) {
        int iMax = serializationMatchStepIndexes.length;
        @NonNull SerializationMatchStep @NonNull [] serializationMatchSteps = new SerializationMatchStep[iMax];
        int i = 0;
        while (i < iMax) {
            serializationMatchSteps[i] = this.getSerializationMatchSteps()[serializationMatchStepIndexes[i]];
            ++i;
        }
        return serializationMatchSteps;
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermAdd(int leftIndex, int rightIndex) {
        return new SerializationMatchTerm.SerializationMatchTermAdd(this.getSerializationMatchTerms()[leftIndex], this.getSerializationMatchTerms()[rightIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermDivide(int leftIndex, int rightIndex) {
        return new SerializationMatchTerm.SerializationMatchTermDivide(this.getSerializationMatchTerms()[leftIndex], this.getSerializationMatchTerms()[rightIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermEAttributeSize(EAttribute eAttribute, int enumerationValueIndex) {
        assert (eAttribute != null);
        return new SerializationMatchTerm.SerializationMatchTermEAttributeSize(eAttribute, this.getEnumerationValues()[enumerationValueIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermEReferenceSize(EReference eReference, int grammarRuleVectorIndex) {
        assert (eReference != null);
        return new SerializationMatchTerm.SerializationMatchTermEReferenceSize(eReference, this.getGrammarRuleVectors()[grammarRuleVectorIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermEStructuralFeatureSize(EStructuralFeature eStructuralFeature) {
        assert (eStructuralFeature != null);
        return new SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize(eStructuralFeature);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermGreaterThan(int leftIndex, int rightIndex) {
        return new SerializationMatchTerm.SerializationMatchTermGreaterThan(this.getSerializationMatchTerms()[leftIndex], this.getSerializationMatchTerms()[rightIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermInteger(int value) {
        return new SerializationMatchTerm.SerializationMatchTermInteger(value);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermMultiply(int leftIndex, int rightIndex) {
        return new SerializationMatchTerm.SerializationMatchTermMultiply(this.getSerializationMatchTerms()[leftIndex], this.getSerializationMatchTerms()[rightIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermRuntime() {
        return new SerializationMatchTerm(){

            @Override
            protected int computeHashCode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void toString(@NonNull DiagnosticStringBuilder s) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermSubtract(int leftIndex, int rightIndex) {
        return new SerializationMatchTerm.SerializationMatchTermSubtract(this.getSerializationMatchTerms()[leftIndex], this.getSerializationMatchTerms()[rightIndex]);
    }

    protected @NonNull SerializationMatchTerm createSerializationMatchTermVariable(int cardinalityVariableIndex) {
        return new SerializationMatchTerm.SerializationMatchTermVariable(cardinalityVariableIndex);
    }

    protected @NonNull SerializationRule.SerializationReference createSerializationReference(EReference eReference, int targetGrammarRuleVectorIndex, int ... grammarRuleIndex_grammarCardinalities) {
        assert (eReference != null);
        GrammarRuleVector targetGrammarRuleVector = targetGrammarRuleVectorIndex >= 0 ? this.getGrammarRuleVectors()[targetGrammarRuleVectorIndex] : null;
        int iMax = grammarRuleIndex_grammarCardinalities.length;
        int @NonNull [] grammarRuleIndexes = new int[iMax];
        @NonNull GrammarCardinality @NonNull [] grammarCardinalities = new GrammarCardinality[iMax];
        int i = 0;
        while (i < iMax) {
            grammarRuleIndexes[i] = grammarRuleIndex_grammarCardinalities[i] >> 4;
            grammarCardinalities[i] = GrammarCardinality.valueOf(grammarRuleIndex_grammarCardinalities[i] & 0xF);
            ++i;
        }
        return new SerializationRule.SerializationReference(eReference, targetGrammarRuleVector, grammarRuleIndexes, grammarCardinalities);
    }

    protected @NonNull SerializationRule createSerializationRule(@NonNull String name, int grammarRuleValueIndex, @NonNull SerializationMatchStep @Nullable [] matchSteps, @NonNull SerializationStep @NonNull [] serializationSteps, @NonNull SerializationRule.SerializationFeature @Nullable [] serializationFeatures) {
        return new SerializationRule(this, name, grammarRuleValueIndex, matchSteps, serializationSteps, serializationFeatures);
    }

    protected @NonNull SerializationRule @NonNull [] createSerializationRules(int ... serializationRuleIndexes) {
        int iMax = serializationRuleIndexes.length;
        @NonNull SerializationRule @NonNull [] serializationRules = new SerializationRule[iMax];
        int i = 0;
        while (i < iMax) {
            serializationRules[i] = this.getSerializationRules()[serializationRuleIndexes[i]];
            ++i;
        }
        return serializationRules;
    }

    protected @NonNull SerializationRule.SerializationAttribute createSerializationSimpleAttribute(EAttribute eAttribute, boolean needsDefault, @NonNull GrammarCardinality grammarCardinality) {
        assert (eAttribute != null);
        return new SerializationRule.SerializationSimpleAttribute(eAttribute, needsDefault, grammarCardinality);
    }

    protected @NonNull SerializationStep createSerializationStepAssignKeyword(EStructuralFeature eStructuralFeature, int enumerationValueIndex, int serializationSegmentsIndex) {
        assert (eStructuralFeature != null);
        return new SerializationStep.SerializationStepAssignKeyword(eStructuralFeature, this.getEnumerationValues()[enumerationValueIndex], serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepAssignedRuleCall(EStructuralFeature eStructuralFeature, int calledValueIndex, int serializationSegmentsIndex) {
        assert (eStructuralFeature != null);
        return new SerializationStep.SerializationStepAssignedRuleCall(eStructuralFeature, calledValueIndex, serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepAssigns(EStructuralFeature eStructuralFeature, int enumerationValueIndex, int @NonNull [] calledRuleIndexes, int serializationSegmentsIndex) {
        assert (eStructuralFeature != null);
        return new SerializationStep.SerializationStepAssigns(eStructuralFeature, enumerationValueIndex >= 0 ? this.getEnumerationValues()[enumerationValueIndex] : EnumerationValue.EnumerationValueNull.INSTANCE, calledRuleIndexes, serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepCrossReference(EStructuralFeature eStructuralFeature, @NonNull CrossReference crossReference, int calledRuleIndex, int serializationSegmentsIndex) {
        assert (eStructuralFeature != null);
        return new SerializationStep.SerializationStepCrossReference(eStructuralFeature, crossReference, calledRuleIndex, serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepKeyword(@NonNull String keyword, int serializationSegmentsIndex) {
        return new SerializationStep.SerializationStepKeyword(keyword, serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepSequence(int variableIndex_grammarCardinality, int stepsRange, int serializationSegmentsIndex) {
        int variableIndex = variableIndex_grammarCardinality >> 4;
        GrammarCardinality grammarCardinality = GrammarCardinality.valueOf(variableIndex_grammarCardinality & 0xF);
        return new SerializationStep.SerializationStepSequence(variableIndex, stepsRange, grammarCardinality, serializationSegmentsIndex >= 0 ? this.getSerializationSegments()[serializationSegmentsIndex] : null);
    }

    protected @NonNull SerializationStep createSerializationStepWrapper(int serializationSegmentsIndex) {
        assert (serializationSegmentsIndex >= 0);
        @NonNull SerializationSegment[] serializationSegments = this.getSerializationSegments()[serializationSegmentsIndex];
        assert (serializationSegments != null);
        return new SerializationStep.SerializationStepWrapper(serializationSegments);
    }

    protected @NonNull SerializationStep @NonNull [] createSerializationSteps(int ... serializationStepIndexes) {
        @NonNull SerializationStep @NonNull [] allSerializationSteps = this.getSerializationSteps();
        int iMax = serializationStepIndexes.length;
        @NonNull SerializationStep @NonNull [] serializationSteps = new SerializationStep[iMax];
        int i = 0;
        while (i < iMax) {
            serializationSteps[i] = allSerializationSteps[serializationStepIndexes[i]];
            ++i;
        }
        return serializationSteps;
    }

    protected @NonNull SubstringStep createSubstringStep(@NonNull String string, int serializationStepsIndex) {
        @NonNull SerializationSegment[] serializationSegments = this.getSerializationSegments()[serializationStepsIndex];
        return new SubstringStep(string, serializationSegments);
    }

    protected @NonNull SubstringStep @NonNull [] createSubstringSteps(int ... substringStepIndexes) {
        int iMax = substringStepIndexes.length;
        @NonNull SubstringStep @NonNull [] substringSteps = new SubstringStep[iMax];
        int i = 0;
        while (i < iMax) {
            substringSteps[i] = this.getSubstringSteps()[substringStepIndexes[i]];
            ++i;
        }
        return substringSteps;
    }

    public @NonNull CrossReference getCrossReference(EReference assignedEReference, @NonNull String assignedRuleName) {
        CrossReference crossReference;
        Map<String, CrossReference> ruleName2crossReference;
        Map<@NonNull EReference, @NonNull Map<@NonNull String, @NonNull CrossReference>> eReference2ruleName2crossReference2 = this.eReference2ruleName2crossReference;
        if (eReference2ruleName2crossReference2 == null) {
            this.eReference2ruleName2crossReference = eReference2ruleName2crossReference2 = new HashMap<EReference, Map<String, CrossReference>>();
            this.analyzeGrammar(this.grammar, eReference2ruleName2crossReference2);
        }
        if ((ruleName2crossReference = eReference2ruleName2crossReference2.get(assignedEReference)) != null && (crossReference = ruleName2crossReference.get(assignedRuleName)) != null) {
            return crossReference;
        }
        throw new IllegalStateException();
    }

    @Override
    public @NonNull EClassValue getEClassValue(@NonNull EClass eClass) {
        return (EClassValue)ClassUtil.nonNullState((Object)this.basicGetEClassValue(eClass));
    }

    public abstract @NonNull EClassValue @NonNull [] getEClassValues();

    public abstract @NonNull EnumerationValue @NonNull [] getEnumerationValues();

    protected abstract int getFirstGlobalSerializationStepAssignmentIndex();

    protected abstract int getFirstGlobalSerializationStepLiteralIndex();

    protected @NonNull Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> getGrammarElement2innerFormattingSegments(@NonNull AbstractElement grammarElement) {
        SerializationSegment[] innerFormattingSegments;
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2innerFormattingSegments2 = this.grammarElement2innerFormattingSegments;
        if (grammarElement2innerFormattingSegments2 == null) {
            this.grammarElement2innerFormattingSegments = grammarElement2innerFormattingSegments2 = new HashMap<AbstractElement, SerializationSegment[]>();
        }
        if ((innerFormattingSegments = grammarElement2innerFormattingSegments2.get(grammarElement)) == null) {
            AbstractRule grammarRule = GrammarUtil.containingRule((EObject)grammarElement);
            assert (grammarRule != null);
            GrammarRuleValue grammarRuleValue = this.basicGetGrammarRuleValue(SerializationUtils.getName(grammarRule));
            if (grammarRuleValue instanceof ParserRuleValue) {
                this.setInnerFormattingSegments(SerializationUtils.getAlternatives(grammarRule), 0, ((ParserRuleValue)grammarRuleValue).getInnerFormattingSegments());
            } else if (grammarRuleValue instanceof DataTypeRuleValue) {
                String value = grammarElement instanceof Keyword ? ((Keyword)grammarElement).getValue() : null;
                @NonNull SerializationSegment[] serializationSegments = ((DataTypeRuleValue)grammarRuleValue).getSerializationSegments(value);
                grammarElement2innerFormattingSegments2.put(grammarElement, serializationSegments);
            }
        }
        return grammarElement2innerFormattingSegments2;
    }

    protected @NonNull Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> getGrammarElement2outerFormattingSegments(@NonNull AbstractElement grammarElement) {
        SerializationSegment[] outerFormattingSegments;
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2outerFormattingSegments2 = this.grammarElement2outerFormattingSegments;
        if (grammarElement2outerFormattingSegments2 == null) {
            this.grammarElement2outerFormattingSegments = grammarElement2outerFormattingSegments2 = new HashMap<AbstractElement, SerializationSegment[]>();
        }
        if ((outerFormattingSegments = grammarElement2outerFormattingSegments2.get(grammarElement)) == null) {
            AbstractRule grammarRule = GrammarUtil.containingRule((EObject)grammarElement);
            assert (grammarRule != null);
            GrammarRuleValue grammarRuleValue = this.basicGetGrammarRuleValue(SerializationUtils.getName(grammarRule));
            if (grammarRuleValue instanceof ParserRuleValue) {
                this.setOuterFormattingSegments(SerializationUtils.getAlternatives(grammarRule), 0, ((ParserRuleValue)grammarRuleValue).getOuterFormattingSegments());
            }
        }
        return grammarElement2outerFormattingSegments2;
    }

    @Override
    public @NonNull GrammarRuleValue getGrammarRuleValue(int ruleValueIndex) {
        return this.getGrammarRuleValues()[ruleValueIndex];
    }

    public abstract @NonNull GrammarRuleValue @NonNull [] getGrammarRuleValues();

    public abstract @NonNull GrammarRuleVector @NonNull [] getGrammarRuleVectors();

    @Override
    public @NonNull SerializationSegment @NonNull [] getInnerFormattingSegments(@NonNull AbstractElement grammarElement) {
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2innerFormattingSegments2 = this.getGrammarElement2innerFormattingSegments(grammarElement);
        @NonNull SerializationSegment[] innerFormattingSegments = grammarElement2innerFormattingSegments2.get(grammarElement);
        return innerFormattingSegments != null ? innerFormattingSegments : SerializationSegment.VALUE_SEGMENTS_ARRAY;
    }

    protected abstract int getLastGlobalSerializationStepAssignmentIndex();

    protected abstract int getLastGlobalSerializationStepLiteralIndex();

    @Override
    public @NonNull SerializationSegment @NonNull [] getOuterFormattingSegments(@NonNull AbstractElement grammarElement) {
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2outerFormattingSegments2 = this.getGrammarElement2outerFormattingSegments(grammarElement);
        @NonNull SerializationSegment[] outerFormattingSegments = grammarElement2outerFormattingSegments2.get(grammarElement);
        return outerFormattingSegments != null ? outerFormattingSegments : SerializationSegment.VALUE_SEGMENTS_ARRAY;
    }

    public abstract @NonNull SerializationMatchStep @NonNull [] getSerializationMatchSteps();

    public abstract @NonNull SerializationMatchTerm @NonNull [] getSerializationMatchTerms();

    public abstract @NonNull SerializationRule @NonNull [] getSerializationRules();

    public abstract @NonNull SerializationSegment @NonNull [] @NonNull [] getSerializationSegments();

    public @NonNull SerializationSegment @NonNull [] @NonNull [] @Nullable [] getSerializationSegmentsArrays() {
        throw new UnsupportedOperationException();
    }

    public abstract @NonNull SerializationStep @NonNull [] getSerializationSteps();

    public abstract @NonNull SubstringStep @NonNull [] getSubstringSteps();

    private int setInnerFormattingSegments(@NonNull AbstractElement grammarElement, int index, @NonNull SerializationSegment @NonNull [] @NonNull [] formattingSegmentsArray) {
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2innerFormattingSegments2 = this.grammarElement2innerFormattingSegments;
        assert (grammarElement2innerFormattingSegments2 != null);
        SerializationSegment[] formattingSegments = formattingSegmentsArray[index++];
        EObject parentGrammarElement = grammarElement.eContainer();
        if (parentGrammarElement instanceof Group && ((Group)parentGrammarElement).getElements().get(0) == grammarElement) {
            @NonNull SerializationSegment[] parentSerializationSegments = grammarElement2innerFormattingSegments2.get(parentGrammarElement);
            assert (parentSerializationSegments != null);
        }
        grammarElement2innerFormattingSegments2.put(grammarElement, formattingSegments);
        if (grammarElement instanceof CompoundElement) {
            for (AbstractElement nestedElement : SerializationUtils.getElements((CompoundElement)grammarElement)) {
                index = this.setInnerFormattingSegments(nestedElement, index, formattingSegmentsArray);
            }
        }
        return index;
    }

    private int setOuterFormattingSegments(@NonNull AbstractElement grammarElement, int index, @NonNull SerializationSegment @NonNull [] @NonNull [] formattingSegmentsArray) {
        Map<@NonNull AbstractElement, @NonNull SerializationSegment @NonNull []> grammarElement2outerFormattingSegments2 = this.grammarElement2outerFormattingSegments;
        assert (grammarElement2outerFormattingSegments2 != null);
        SerializationSegment[] formattingSegments = formattingSegmentsArray[index++];
        EObject parentGrammarElement = grammarElement.eContainer();
        if (parentGrammarElement instanceof Group && ((Group)parentGrammarElement).getElements().get(0) == grammarElement) {
            @NonNull SerializationSegment[] parentSerializationSegments = grammarElement2outerFormattingSegments2.get(parentGrammarElement);
            assert (parentSerializationSegments != null);
        }
        grammarElement2outerFormattingSegments2.put(grammarElement, formattingSegments);
        if (grammarElement instanceof CompoundElement) {
            for (AbstractElement nestedElement : SerializationUtils.getElements((CompoundElement)grammarElement)) {
                index = this.setOuterFormattingSegments(nestedElement, index, formattingSegmentsArray);
            }
        }
        return index;
    }
}

