/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.TupleTypeImpl;
import org.eclipse.ocl.pivot.internal.TypedElementImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotIdResolver;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class TupleTypeManager {
    protected final @NonNull CompleteEnvironmentInternal completeEnvironment;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull Class oclTupleType;
    private @Nullable Map<@NonNull TupleTypeId, @NonNull TupleType> tupleid2tuple = null;

    public TupleTypeManager(@NonNull CompleteEnvironmentInternal allCompleteClasses) {
        this.completeEnvironment = allCompleteClasses;
        this.metamodelManager = allCompleteClasses.getEnvironmentFactory().getMetamodelManager();
        this.oclTupleType = this.metamodelManager.getStandardLibrary().getOclTupleType();
    }

    public void dispose() {
        this.tupleid2tuple = null;
    }

    public @Nullable Type getCommonType(@NonNull TupleType leftType, @NonNull TemplateParameterSubstitutions leftSubstitutions, @NonNull TupleType rightType, @NonNull TemplateParameterSubstitutions rightSubstitutions) {
        List<Property> leftProperties = leftType.getOwnedProperties();
        List<Property> rightProperties = rightType.getOwnedProperties();
        int iSize = leftProperties.size();
        if (iSize != rightProperties.size()) {
            return null;
        }
        ArrayList<@NonNull TuplePartId> commonPartIds = new ArrayList<TuplePartId>(iSize);
        int i = 0;
        while (i < iSize) {
            Property leftProperty = leftProperties.get(i);
            if (leftProperty == null) {
                return null;
            }
            String name = leftProperty.getName();
            if (name == null) {
                return null;
            }
            Property rightProperty = NameUtil.getNameable(rightProperties, name);
            if (rightProperty == null) {
                return null;
            }
            Type leftPropertyType = leftProperty.getType();
            if (leftPropertyType == null) {
                return null;
            }
            Type rightPropertyType = rightProperty.getType();
            if (rightPropertyType == null) {
                return null;
            }
            Type commonType = this.metamodelManager.getCommonType(leftPropertyType, leftSubstitutions, rightPropertyType, rightSubstitutions);
            TuplePartId commonPartId = IdManager.getTuplePartId(i, name, commonType.getTypeId());
            commonPartIds.add(commonPartId);
            ++i;
        }
        TupleTypeId commonTupleTypeId = IdManager.getTupleTypeId("Tuple", commonPartIds);
        return this.getTupleType(this.metamodelManager.getEnvironmentFactory().getIdResolver(), commonTupleTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TupleType getTupleType(@NonNull IdResolver idResolver, @NonNull TupleTypeId tupleTypeId) {
        TupleType tupleType;
        Map<@NonNull TupleTypeId, @NonNull TupleType> tupleid2tuple2 = this.tupleid2tuple;
        if (tupleid2tuple2 == null) {
            TupleTypeManager tupleTypeManager = this;
            synchronized (tupleTypeManager) {
                tupleid2tuple2 = this.tupleid2tuple;
                if (tupleid2tuple2 == null) {
                    tupleid2tuple2 = this.tupleid2tuple = new HashMap<TupleTypeId, TupleType>();
                }
            }
        }
        if ((tupleType = tupleid2tuple2.get(tupleTypeId)) == null) {
            Map<TupleTypeId, TupleType> map = tupleid2tuple2;
            synchronized (map) {
                tupleType = tupleid2tuple2.get(tupleTypeId);
                if (tupleType == null) {
                    tupleType = new TupleTypeImpl(tupleTypeId);
                    @NonNull TuplePartId[] partIds = tupleTypeId.getPartIds();
                    List<Property> ownedAttributes = tupleType.getOwnedProperties();
                    TuplePartId[] tuplePartIdArray = partIds;
                    int n = partIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TuplePartId partId = tuplePartIdArray[n2];
                        Type partType = idResolver.getType(partId.getTypeId(), tupleType);
                        Type partType2 = this.metamodelManager.getPrimaryType(partType);
                        Property property = PivotUtil.createProperty(NameUtil.getSafeName(partId), partType2);
                        ownedAttributes.add(property);
                        ++n2;
                    }
                    tupleType.getSuperClasses().add(this.oclTupleType);
                    tupleid2tuple2.put(tupleTypeId, tupleType);
                    this.completeEnvironment.addOrphanClass(tupleType);
                }
            }
        }
        return tupleType;
    }

    public @NonNull TupleType getTupleType(@NonNull String tupleName, @NonNull Collection<@NonNull ? extends TypedElement> parts, @Nullable TemplateParameterSubstitutions usageBindings) {
        HashMap<@NonNull String, @NonNull Type> partMap = new HashMap<String, Type>();
        for (TypedElement typedElement : parts) {
            Type type1 = typedElement.getType();
            if (type1 == null) continue;
            Type type2 = this.metamodelManager.getPrimaryType(type1);
            Type type3 = this.completeEnvironment.getSpecializedType(type2, usageBindings);
            partMap.put(PivotUtil.getName(typedElement), type3);
        }
        return this.getTupleType(tupleName, partMap);
    }

    public @NonNull TupleType getTupleType(@NonNull String tupleName, @NonNull Map<@NonNull String, @NonNull ? extends Type> parts) {
        @NonNull Collection<? extends Type> partValues = parts.values();
        TemplateParameterReferencesVisitor referencesVisitor = new TemplateParameterReferencesVisitor(this.metamodelManager.getEnvironmentFactory(), partValues);
        int partsCount = parts.size();
        @NonNull TuplePartId[] newPartIds = new TuplePartId[partsCount];
        ArrayList<@NonNull String> sortedPartNames = new ArrayList<String>(parts.keySet());
        Collections.sort(sortedPartNames);
        int i = 0;
        while (i < partsCount) {
            @NonNull String partName = (String)sortedPartNames.get(i);
            Type partType = parts.get(partName);
            if (partType != null) {
                TuplePartId tuplePartId;
                TypeId partTypeId = partType.getTypeId();
                newPartIds[i] = tuplePartId = IdManager.getTuplePartId(i, partName, partTypeId);
            }
            ++i;
        }
        TupleTypeId tupleTypeId = IdManager.getOrderedTupleTypeId(tupleName, newPartIds);
        TupleIdResolver pivotIdResolver = new TupleIdResolver(this.metamodelManager.getEnvironmentFactory(), referencesVisitor);
        TupleType tupleType = this.getTupleType(pivotIdResolver, tupleTypeId);
        return tupleType;
    }

    public @NonNull TupleType getTupleType(@NonNull TupleType type, @Nullable TemplateParameterSubstitutions usageBindings) {
        TupleType specializedTupleType = type;
        HashMap<String, Type> resolutions = null;
        List<Property> parts = specializedTupleType.getOwnedProperties();
        for (Property part : parts) {
            Type resolvedPropertyType;
            Type propertyType;
            if (part == null || (propertyType = PivotUtilInternal.getType(part)) == null || (resolvedPropertyType = this.completeEnvironment.getSpecializedType(propertyType, usageBindings)) == propertyType) continue;
            if (resolutions == null) {
                resolutions = new HashMap<String, Type>();
            }
            resolutions.put(NameUtil.getSafeName(part), resolvedPropertyType);
        }
        if (resolutions != null) {
            ArrayList<@NonNull TuplePartId> partIds = new ArrayList<TuplePartId>(parts.size());
            int i = 0;
            while (i < parts.size()) {
                @NonNull Property part = parts.get(i);
                String partName = NameUtil.getSafeName(part);
                Type resolvedPropertyType = (Type)resolutions.get(partName);
                TypeId partTypeId = resolvedPropertyType != null ? resolvedPropertyType.getTypeId() : part.getTypeId();
                TuplePartId tuplePartId = IdManager.getTuplePartId(i, partName, partTypeId);
                partIds.add(tuplePartId);
                ++i;
            }
            TupleTypeId tupleTypeId = IdManager.getTupleTypeId(ClassUtil.nonNullModel(type.getName()), partIds);
            specializedTupleType = this.getTupleType(this.metamodelManager.getEnvironmentFactory().getIdResolver(), tupleTypeId);
            return specializedTupleType;
        }
        return this.getTupleType(NameUtil.getSafeName(type), ClassUtil.nullFree(type.getOwnedProperties()), usageBindings);
    }

    protected static class TemplateParameterReferencesVisitor
    extends TemplateParameterSubstitutionVisitor {
        protected final @NonNull Map<@NonNull Integer, @NonNull TemplateParameter> templateParameters = new HashMap<Integer, TemplateParameter>();

        public TemplateParameterReferencesVisitor(@NonNull EnvironmentFactoryInternal environmentFactory, Collection<? extends Type> partValues) {
            super(environmentFactory, null, null);
            for (Type type : partValues) {
                this.analyzeType(type, type);
            }
        }

        @Override
        public @NonNull Type put(@NonNull TemplateParameter formalTemplateParameter, @NonNull Type actualType) {
            this.templateParameters.put(formalTemplateParameter.getTemplateParameterId().getIndex(), formalTemplateParameter);
            return super.put(formalTemplateParameter, actualType);
        }
    }

    protected static class TupleIdResolver
    extends PivotIdResolver {
        private final TemplateParameterReferencesVisitor referencesVisitor;

        private TupleIdResolver(@NonNull EnvironmentFactoryInternal environmentFactory, TemplateParameterReferencesVisitor referencesVisitor) {
            super(environmentFactory);
            this.referencesVisitor = referencesVisitor;
        }

        @Override
        public @NonNull Element visitTemplateParameterId(@NonNull TemplateParameterId id) {
            int index = id.getIndex();
            TemplateParameter templateParameter = this.referencesVisitor.templateParameters.get(index);
            if (templateParameter != null) {
                return templateParameter;
            }
            return super.visitTemplateParameterId(id);
        }
    }

    public static class TuplePart
    extends TypedElementImpl {
        protected final @NonNull TuplePartId partId;

        public TuplePart(@NonNull TuplePartId partId) {
            this.partId = partId;
            this.setName(partId.getName());
        }

        @Override
        public @NonNull TypeId getTypeId() {
            return this.partId.getTypeId();
        }

        @Override
        public String toString() {
            return String.valueOf(String.valueOf(this.name)) + " : " + String.valueOf(this.type);
        }
    }
}

