/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModel
extends DefaultListSelectionModel
implements MutableComboBoxModel {
    private ArrayList m_items = new ArrayList();
    private CopyOnWriteArrayList m_lstnrs = new CopyOnWriteArrayList();

    public ListModel() {
    }

    public ListModel(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.m_items.add(items[i]);
            ++i;
        }
    }

    private boolean isMultipleSelection() {
        return this.getMaxSelectionIndex() - this.getMinSelectionIndex() > 0;
    }

    public Object getSelectedItem() {
        int idx = this.getMinSelectionIndex();
        return idx == -1 ? null : this.m_items.get(idx);
    }

    public void setSelectedItem(Object item) {
        int idx = this.m_items.indexOf(item);
        if (idx < 0) {
            return;
        }
        if (!this.isMultipleSelection() && idx == this.getMinSelectionIndex()) {
            return;
        }
        super.setSelectionInterval(idx, idx);
        this.fireDataEvent(this, 0, -1, -1);
    }

    public int getSize() {
        return this.m_items.size();
    }

    public Object getElementAt(int idx) {
        return this.m_items.get(idx);
    }

    public void addElement(Object item) {
        this.m_items.add(item);
        int sz = this.m_items.size() - 1;
        this.fireDataEvent(this, 1, sz, sz);
        if (sz >= 0 && this.isSelectionEmpty() && item != null) {
            this.setSelectedItem(item);
        }
    }

    public void insertElementAt(Object item, int idx) {
        this.m_items.add(idx, item);
        this.fireDataEvent(this, 1, idx, idx);
    }

    public void removeElement(Object item) {
        int idx = this.m_items.indexOf(item);
        if (idx >= 0) {
            this.removeElementAt(idx);
        }
    }

    public void removeElementAt(int idx) {
        if (!this.isMultipleSelection() && idx == this.getMinSelectionIndex()) {
            int sidx = idx == 0 ? (this.getSize() == 1 ? -1 : idx + 1) : idx - 1;
            Object sel = sidx == -1 ? null : this.m_items.get(sidx);
            this.setSelectedItem(sel);
        }
        this.m_items.remove(idx);
        this.fireDataEvent(this, 2, idx, idx);
    }

    public void addListDataListener(ListDataListener l) {
        if (!this.m_lstnrs.contains(l)) {
            this.m_lstnrs.add(l);
        }
    }

    public void removeListDataListener(ListDataListener l) {
        this.m_lstnrs.remove(l);
    }

    protected void fireDataEvent(Object src, int type, int idx0, int idx1) {
        Object[] lstnrs = this.m_lstnrs.toArray();
        if (lstnrs.length > 0) {
            ListDataEvent e = new ListDataEvent(src, type, idx0, idx1);
            int i = 0;
            while (i < lstnrs.length) {
                ((ListDataListener)lstnrs[i]).contentsChanged(e);
                ++i;
            }
        }
    }
}

