/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.util.ColorLib;

public class ColorIntParser
implements DataParser {
    public Class getType() {
        return Integer.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).intValue());
    }

    public boolean canParse(String text) {
        try {
            if (text.charAt(0) != '#') {
                return false;
            }
            ColorIntParser.parseInt(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        return new Integer(ColorIntParser.parseInt(text));
    }

    public static int parseInt(String text) throws DataParseException {
        try {
            return ColorLib.hex(text);
        }
        catch (Exception e) {
            throw new DataParseException(e);
        }
    }
}

