/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.NoSuchTemplateException;
import org.eclipse.internal.xpand2.XpandUtil;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.model.AdvicedDefinition;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolver;
import org.eclipse.internal.xpand2.type.XpandTypesMetaModel;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.internal.xtend.util.Triplet;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.NullEvaluationHandler;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceParser;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandExecutionContextImpl
extends ExecutionContextImpl
implements XpandExecutionContext {
    private static final Log log = LogFactory.getLog(XpandExecutionContextImpl.class);
    protected final Output output;
    protected final ProtectedRegionResolver protectedRegionResolver;
    private List<XpandAdvice> registeredAdvices = new ArrayList<XpandAdvice>();
    private List<Pair<XpandExecutionContextImpl, Statement>> deferredStatements = null;

    public XpandExecutionContextImpl(Output output, ProtectedRegionResolver prs) {
        this(output, prs, null, null, null);
    }

    public XpandExecutionContextImpl(Output output, ProtectedRegionResolver prs, String fileEncoding) {
        this(output, prs, null, null, null);
        this.resourceManager.setFileEncoding(fileEncoding);
    }

    public XpandExecutionContextImpl(Output output, ProtectedRegionResolver prs, Map<String, Variable> globalVars, ExceptionHandler exceptionHandler, NullEvaluationHandler nullEvaluationHandler) {
        this(new TypeSystemImpl(), output, prs, globalVars, exceptionHandler, nullEvaluationHandler);
    }

    public XpandExecutionContextImpl(ResourceManager resourceManager, Output output, ProtectedRegionResolver prs, Map<String, Variable> globalVars, ProgressMonitor monitor, ExceptionHandler exceptionHandler, NullEvaluationHandler nullEvaluationHandler, VetoableCallback callback) {
        this(resourceManager, null, new TypeSystemImpl(), null, globalVars, output, prs, monitor, exceptionHandler, null, nullEvaluationHandler, null, callback, null, null, null);
    }

    protected XpandExecutionContextImpl(TypeSystemImpl ts, Output output, ProtectedRegionResolver prs, Map<String, Variable> globalVars, ExceptionHandler exceptionHandler, NullEvaluationHandler nullEvaluationHandler) {
        super(ts, globalVars);
        this.registerMetaModel(new XpandTypesMetaModel((TypeSystem)this));
        this.registerParser(this.resourceManager);
        this.output = output;
        this.protectedRegionResolver = prs;
        this.exceptionHandler = exceptionHandler;
        this.nullEvaluationHandler = nullEvaluationHandler;
    }

    protected XpandExecutionContextImpl(ResourceManager resourceManager, Resource currentResource, TypeSystemImpl typeSystem, Map<String, Variable> vars, Map<String, Variable> globalVars, Output output, ProtectedRegionResolver protectedRegionResolver, ProgressMonitor monitor, ExceptionHandler exceptionHandler, List<Around> advices, NullEvaluationHandler nullEvaluationHandler, Map<Resource, Set<Extension>> allExtensionsPerResource, VetoableCallback callback, Cache<Triplet<Resource, String, List<Type>>, Extension> extensionsForNameAndTypesCache, Map<Pair<String, List<Type>>, Type> extensionsReturnTypeCache, List<Pair<XpandExecutionContextImpl, Statement>> deferredStatements) {
        super(resourceManager, currentResource, typeSystem, vars, globalVars, monitor, exceptionHandler, advices, nullEvaluationHandler, allExtensionsPerResource, callback, extensionsForNameAndTypesCache, extensionsReturnTypeCache);
        this.registerMetaModel(new XpandTypesMetaModel((TypeSystem)this));
        this.registerParser(resourceManager);
        this.output = output;
        this.protectedRegionResolver = protectedRegionResolver;
        this.exceptionHandler = exceptionHandler;
        this.deferredStatements = deferredStatements;
    }

    private void registerParser(ResourceManager resourceManager) {
        resourceManager.registerParser("xpt", new ResourceParser(){

            public Resource parse(Reader in, String fileName) {
                return XpandParseFacade.file(in, fileName);
            }
        });
    }

    public ExecutionContextImpl cloneContext() {
        XpandExecutionContextImpl result = new XpandExecutionContextImpl(this.resourceManager, this.currentResource(), this.typeSystem, this.getVisibleVariables(), this.getGlobalVariables(), this.output, this.protectedRegionResolver, this.getMonitor(), this.exceptionHandler, this.registeredExtensionAdvices, this.nullEvaluationHandler, this.allExtensionsPerResource, this.callback, (Cache<Triplet<Resource, String, List<Type>>, Extension>)this.extensionsForNameAndTypesCache, this.extensionsReturnTypeCache, this.deferredStatements);
        result.registeredAdvices.addAll(this.registeredAdvices);
        return result;
    }

    public XpandExecutionContextImpl cloneWithStatement(Statement stmt) {
        XpandExecutionContextImpl result = new XpandExecutionContextImpl(this.resourceManager, this.currentResource(), this.typeSystem, this.getVisibleVariables(), this.getGlobalVariables(), this.output, this.protectedRegionResolver, this.getMonitor(), this.exceptionHandler, this.registeredExtensionAdvices, this.nullEvaluationHandler, this.allExtensionsPerResource, this.callback, (Cache<Triplet<Resource, String, List<Type>>, Extension>)this.extensionsForNameAndTypesCache, this.extensionsReturnTypeCache, this.deferredStatements);
        result.registeredAdvices.addAll(this.registeredAdvices);
        if (this.deferredStatements == null) {
            this.deferredStatements = new ArrayList<Pair<XpandExecutionContextImpl, Statement>>();
        }
        this.deferredStatements.add((Pair<XpandExecutionContextImpl, Statement>)new Pair((Object)this, (Object)stmt));
        return result;
    }

    @Override
    public List<XpandDefinition> getAllDefinitions() {
        XpandResource tpl = null;
        tpl = (XpandResource)this.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandDefinition[] localDefinitions = tpl.getDefinitions();
        ArrayList<XpandDefinition> advicedDefinitions = new ArrayList<XpandDefinition>(localDefinitions.length);
        int i = 0;
        while (i < localDefinitions.length) {
            XpandDefinition xpandDefinition = localDefinitions[i];
            int x = this.registeredAdvices.size() - 1;
            while (x >= 0) {
                XpandAdvice adv = this.registeredAdvices.get(x);
                if (adv.matches(xpandDefinition, this)) {
                    xpandDefinition = new AdvicedDefinition(adv, xpandDefinition);
                }
                --x;
            }
            advicedDefinitions.add(xpandDefinition);
            ++i;
        }
        return advicedDefinitions;
    }

    @Override
    public XpandDefinition findDefinition(String name, Type target, Type[] paramTypes) {
        XpandResource tpl = null;
        tpl = name.indexOf("::") != -1 ? this.findTemplate(XpandUtil.withoutLastSegment(name)) : (XpandResource)this.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandExecutionContext ctx = (XpandExecutionContext)this.cloneWithResource(tpl);
        XpandDefinition def = this.findDefinition(tpl.getDefinitions(), name, target, paramTypes, ctx);
        if (def != null) {
            int x = this.registeredAdvices.size() - 1;
            while (x >= 0) {
                XpandAdvice adv = this.registeredAdvices.get(x);
                if (adv.matches(def, this)) {
                    def = new AdvicedDefinition(adv, def);
                }
                --x;
            }
        }
        return def;
    }

    public void registerAdvices(String fullyQualifiedName) {
        XpandResource tpl = this.findTemplate(fullyQualifiedName);
        if (tpl == null) {
            throw new NoSuchTemplateException(fullyQualifiedName);
        }
        XpandAdvice[] as = tpl.getAdvices();
        int i = 0;
        while (i < as.length) {
            XpandAdvice advice = as[i];
            if (this.registeredAdvices.contains(advice)) {
                log.warn((Object)("advice " + advice.toString() + " allready registered!"));
            } else {
                this.registeredAdvices.add(advice);
            }
            ++i;
        }
    }

    @Override
    public ProtectedRegionResolver getProtectedRegionResolver() {
        return this.protectedRegionResolver;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public XpandResource findTemplate(String templateName) {
        return this.findTemplate(templateName, this.getImportedNamespaces());
    }

    public XpandResource findTemplate(String templateName, String[] importedNs) {
        List possibleNames = this.typeSystem.getPossibleNames(templateName, importedNs);
        for (String element : possibleNames) {
            XpandResource tpl = (XpandResource)this.resourceManager.loadResource(element, "xpt");
            if (tpl == null) continue;
            return tpl;
        }
        return null;
    }

    private XpandDefinition findDefinition(XpandDefinition[] definitions, String name, Type target, Type[] paramTypes, XpandExecutionContext ctx) {
        if (paramTypes == null) {
            paramTypes = new Type[]{};
        }
        HashSet<DefinitionOperationAdapter> features = new HashSet<DefinitionOperationAdapter>();
        int i = 0;
        while (i < definitions.length) {
            XpandDefinition def = definitions[i];
            if (def.getParams().length == paramTypes.length) {
                ArrayList<Type> defsParamTypes = new ArrayList<Type>();
                Type t = null;
                boolean complete = true;
                int j = 0;
                while (j < paramTypes.length && complete) {
                    t = ctx.getTypeForName(def.getParams()[j].getType().getValue());
                    if (t == null) {
                        complete = false;
                    }
                    defsParamTypes.add(t);
                    ++j;
                }
                t = ctx.getTypeForName(def.getTargetType());
                if (t == null) {
                    complete = false;
                }
                if (complete) {
                    features.add(new DefinitionOperationAdapter(def, def.getName(), t, defsParamTypes));
                }
            }
            ++i;
        }
        DefinitionOperationAdapter defAdapter = (DefinitionOperationAdapter)PolymorphicResolver.getOperation(features, (String)XpandUtil.getLastSegment(name), (Type)target, Arrays.asList(paramTypes));
        if (defAdapter != null) {
            return defAdapter.def;
        }
        return null;
    }

    @Deprecated
    public void setResourceManager(ResourceManager resourceManager) {
        throw new UnsupportedOperationException("Context must be immutable, use the existing constructors");
    }

    public List<Pair<XpandExecutionContextImpl, Statement>> getDeferredStatements() {
        return this.deferredStatements != null ? this.deferredStatements : Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefinitionOperationAdapter
    implements Operation {
        private String name;
        private Type owner;
        private List<Type> paramTypes;
        public XpandDefinition def;

        public DefinitionOperationAdapter(XpandDefinition def, String name, Type owner, List<Type> paramTypes) {
            this.name = name;
            this.owner = owner;
            this.paramTypes = paramTypes;
            this.def = def;
        }

        public String getName() {
            return this.name;
        }

        public Type getReturnType() {
            throw new UnsupportedOperationException();
        }

        public Type getOwner() {
            return this.owner;
        }

        public List<Type> getParameterTypes() {
            return this.paramTypes;
        }

        public Object evaluate(Object target, Object[] params) {
            throw new UnsupportedOperationException();
        }

        public String getDocumentation() {
            return "Xpand definition " + this.getName() + " adapted in an Operation";
        }

        public Type getReturnType(Type targetType, Type[] paramTpes) {
            return this.getReturnType();
        }
    }
}

