/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.internal.providers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramGlobalActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.commands.CopyImageCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.PasteViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class ImageSupportGlobalActionHandler
extends DiagramGlobalActionHandler {
    public boolean canHandle(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return false;
        }
        if (!(cntxt.getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.COPY)) {
            return this.canCopy(cntxt);
        }
        if (actionId.equals(GlobalActionId.CUT)) {
            return this.canCut(cntxt);
        }
        if (actionId.equals(GlobalActionId.PASTE)) {
            return this.canPaste(cntxt);
        }
        return false;
    }

    protected boolean canPaste(IGlobalActionContext cntxt) {
        if (!AWTClipboardHelper.getInstance().isImageCopySupported()) {
            return super.canPaste(cntxt);
        }
        return AWTClipboardHelper.getInstance().hasCustomData();
    }

    protected ICommand getCopyCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart, final boolean isUndoable) {
        if (!AWTClipboardHelper.getInstance().isImageCopySupported()) {
            return super.getCopyCommand(cntxt, diagramPart, isUndoable);
        }
        return new CopyImageCommand(cntxt.getLabel(), (View)diagramPart.getDiagram(), this.getSelectedViews(cntxt.getSelection()), diagramPart.getDiagramEditPart()){

            @Override
            public boolean canUndo() {
                return isUndoable;
            }

            @Override
            public boolean canRedo() {
                return isUndoable;
            }

            @Override
            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return isUndoable ? CommandResult.newOKCommandResult() : super.doUndoWithResult(progressMonitor, info);
            }

            @Override
            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return isUndoable ? CommandResult.newOKCommandResult() : super.doRedoWithResult(progressMonitor, info);
            }

            public void addContext(IUndoContext context) {
                if (isUndoable) {
                    super.addContext(context);
                }
            }

            public void removeContext(IUndoContext context) {
                if (isUndoable) {
                    super.removeContext(context);
                }
            }
        };
    }

    protected PasteViewRequest createPasteViewRequest() {
        if (!AWTClipboardHelper.getInstance().isImageCopySupported()) {
            return super.createPasteViewRequest();
        }
        CustomData data = AWTClipboardHelper.getInstance().getCustomData();
        return new PasteViewRequest(new ICustomData[]{data});
    }
}

