/******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/**
 * A section of the options print dialog that handles the job attributes.
 * 
 * @author James Bruck (jbruck)
 */
public class JobAttributesBlock extends DialogBlock {
	private final DataBindingContext bindings;
	private final PrintOptions options;
	private Binding jobNameBinding;

	JobAttributesBlock(IDialogUnitConverter dluConverter,
			DataBindingContext bindings, PrintOptions options) {
		super(dluConverter);

		this.bindings = bindings;
		this.options = options;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gmf.runtime.common.ui.printing.internal.dialogs.DialogBlock#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		final Realm realm = bindings.getValidationRealm();

		Composite result = group(parent,
				DiagramUIPrintingMessages.JPSOptionsDialog_JobAttributes);
		layout(result, 2);

		layoutHorizontalIndent(layoutAlignRight(label(result,
				DiagramUIPrintingMessages.JPSOptionsDialog_JobName)));
		Text jobName = text(result, 80);

		jobNameBinding = bindings.bindValue(SWTObservables.observeText(jobName, SWT.Modify),
				BeansObservables.observeValue(realm, options,
						PrintOptions.PROPERTY_JOB_NAME), null, null);

		return result;
	}
	
	@Override
	public void dispose() {
		bindings.removeBinding(jobNameBinding);
		jobNameBinding.dispose();	
	}
}
