/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BitBlt;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BitmapHelper;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class StretchBlt
extends BitBlt {
    private static final int EMF_WSRC_OFFSET = 92;
    private static final int EMF_HSRC_OFFSET = 96;
    private static final int WMF_XDEST_OFFSET = 20;
    private static final int WMF_YDEST_OFFSET = 18;
    private static final int WMF_WDEST_OFFSET = 16;
    private static final int WMF_HDEST_OFFSET = 14;
    private static final int WMF_XSRC_OFFSET = 12;
    private static final int WMF_YSRC_OFFSET = 10;
    private static final int WMF_WSRC_OFFSET = 8;
    private static final int WMF_HSRC_OFFSET = 6;
    private static final int WMF_USAGE_OFFSET = 4;
    private static final int WMF_BMI_OFFSET = 22;
    protected int m_wSrc = 0;
    protected int m_hSrc = 0;

    public void readWMFRecord(Record rec) throws IOException {
        this.m_xDest = rec.getShortAt(20);
        this.m_yDest = rec.getShortAt(18);
        this.m_wDest = rec.getShortAt(16);
        this.m_hDest = rec.getShortAt(14);
        this.m_xSrc = rec.getShortAt(12);
        this.m_ySrc = rec.getShortAt(10);
        this.m_wSrc = rec.getShortAt(8);
        this.m_hSrc = rec.getShortAt(6);
        short usage = rec.getShortAt(4);
        int bmiSize = BitmapHelper.getHeaderSize(rec, 22, usage);
        int dataOffset = 22 + bmiSize;
        int dataSize = rec.getSize() - dataOffset;
        this.m_image = BitmapHelper.readBitmap(rec, 22, bmiSize, dataOffset, dataSize);
    }

    public void readEMFRecord(Record rec) throws IOException {
        super.readEMFRecord(rec);
        this.m_wSrc = rec.getIntAt(92);
        this.m_hSrc = rec.getIntAt(96);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        int w = this.m_image.getWidth();
        int h = this.m_image.getHeight();
        int xDest = context.convertXToSVGLogicalUnits(this.m_xDest);
        int yDest = context.convertYToSVGLogicalUnits(this.m_yDest);
        int wDest = context.scaleX(this.m_wDest);
        int hDest = context.scaleY(this.m_hDest);
        if (this.m_xSrc >= w || this.m_ySrc >= h) {
            return;
        }
        if (this.m_xSrc + this.m_wSrc > w) {
            this.m_wSrc = w - this.m_xSrc;
        }
        if (this.m_ySrc + this.m_hSrc > h) {
            this.m_hSrc = h - this.m_ySrc;
        }
        BufferedImage image = this.m_image.getSubimage(this.m_xSrc, this.m_ySrc, this.m_wSrc, this.m_hSrc);
        double scaleFactorX = (double)wDest / (double)this.m_wSrc;
        double scaleFactorY = (double)hDest / (double)this.m_hSrc;
        AffineTransform xform = new AffineTransform();
        xform.translate(xDest, yDest);
        xform.scale(scaleFactorX, scaleFactorY);
        g.drawImage(image, xform, null);
    }
}

