/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ReverseScanner;
import org.eclipse.gmf.internal.xpand.expression.codeassist.TypeProposalComputer;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.xtend.ast.GenericExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionProposalComputer
implements ProposalComputer {
    private ExecutionContext executionContext;
    private final ProposalFactory proposalFactory;
    private final ExpressionSimpleAnalyzer exprAnalyzer;

    public ExpressionProposalComputer(ProposalFactory factory) {
        assert (factory != null);
        this.proposalFactory = factory;
        ExpressionSimpleAnalyzer cached = Activator.findState(ExpressionSimpleAnalyzer.class);
        if (cached == null) {
            cached = new ExpressionSimpleAnalyzer();
            Activator.putState(ExpressionSimpleAnalyzer.class, cached);
        }
        this.exprAnalyzer = cached;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext context) {
        try {
            EClassifier targetType;
            String[] s = this.exprAnalyzer.computePrefixAndTargetExpression(txt);
            String prefix = s[0];
            String expressionString = s[1];
            this.executionContext = context;
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            if (prefix.length() > 0 && expressionString == null) {
                proposals.addAll(new TypeProposalComputer(this.proposalFactory).computeProposals(txt, this.executionContext));
            }
            if ((targetType = null) == null) {
                Variable v2;
                for (Variable v2 : this.executionContext.getOCLEnvironment().getVariables()) {
                    String varName = v2.getName();
                    if (!varName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    EClassifier t = (EClassifier)v2.getType();
                    String typeName = AbstractFormattingHelper.INSTANCE.formatType((Object)t);
                    proposals.add(this.proposalFactory.createVariableProposal(varName, typeName, prefix));
                }
                v2 = this.executionContext.getImplicitVariable();
                if (v2 != null) {
                    targetType = v2.getType();
                    proposals.addAll(this.getAllMemberProposals(targetType, prefix));
                }
                Set exts = this.executionContext.getAllExtensions();
                for (GenericExtension extension : exts) {
                    if (!extension.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    proposals.add(this.proposalFactory.createExtensionProposal(extension, prefix));
                }
            } else {
                proposals.addAll(this.getAllMemberProposals(targetType, prefix));
            }
            ArrayList<ICompletionProposal> arrayList = proposals;
            return arrayList;
        }
        finally {
            this.executionContext = null;
        }
    }

    private List<ICompletionProposal> getAllMemberProposals(EClassifier targetType, String prefix) {
        if (targetType == null) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.internalGetAllMemberProposals(targetType, prefix, false));
        if (targetType instanceof CollectionType) {
            result.addAll(this.getAllCollectionOperations(prefix));
            targetType = (EClassifier)((CollectionType)targetType).getElementType();
            result.addAll(this.internalGetAllMemberProposals(targetType, prefix, true));
        }
        return result;
    }

    private List<ICompletionProposal> internalGetAllMemberProposals(EClassifier targetType, String prefix, boolean onCollection) {
        LinkedList<ICompletionProposal> result = new LinkedList<ICompletionProposal>();
        String prefixLowerCase = prefix.toLowerCase();
        for (EStructuralFeature f : ExpressionProposalComputer.getAllFeatures(targetType, this.executionContext)) {
            if (!f.getName().toLowerCase().startsWith(prefixLowerCase)) continue;
            result.add(this.proposalFactory.createPropertyProposal(f, prefix, onCollection));
        }
        for (EOperation op : ExpressionProposalComputer.getAllOperation(targetType, this.executionContext)) {
            if (!op.getName().toLowerCase().startsWith(prefixLowerCase) || !Character.isJavaIdentifierStart(op.getName().charAt(0))) continue;
            result.add(this.proposalFactory.createOperationProposal(op, prefix, onCollection));
        }
        for (GenericExtension e : this.executionContext.getAllExtensions()) {
            if (!e.getName().toLowerCase().startsWith(prefixLowerCase) || e.getParameterTypes().size() < 1 || !BuiltinMetaModel.isAssignableFrom((ExecutionContext)this.executionContext, (EClassifier)((EClassifier)e.getParameterTypes().get(0)), (EClassifier)targetType)) continue;
            result.add(this.proposalFactory.createExtensionOnMemberPositionProposal(e, prefix, onCollection));
        }
        return result;
    }

    private static List<EStructuralFeature> getAllFeatures(EClassifier targetType, ExecutionContext ctx) {
        List r2 = ctx.getOCLEnvironment().getTypeResolver().getAdditionalAttributes((Object)targetType);
        if (targetType instanceof EClass) {
            EList r1 = ((EClass)targetType).getEAllStructuralFeatures();
            ArrayList<EStructuralFeature> rv = new ArrayList<EStructuralFeature>(r1.size() + r2.size());
            rv.addAll((Collection<EStructuralFeature>)r1);
            rv.addAll(r2);
            return rv;
        }
        return r2;
    }

    private static List<EOperation> getAllOperation(EClassifier targetType, ExecutionContext ctx) {
        List r2 = ctx.getOCLEnvironment().getTypeResolver().getAdditionalOperations((Object)targetType);
        if (targetType instanceof PredefinedType) {
            PredefinedType t = (PredefinedType)targetType;
            EList r1 = t.oclOperations();
            ArrayList<EOperation> rv = new ArrayList<EOperation>(r1.size() + r2.size());
            rv.addAll((Collection<EOperation>)r1);
            rv.addAll(r2);
            return rv;
        }
        if (targetType instanceof EClass) {
            EList r1 = ((EClass)targetType).getEAllOperations();
            ArrayList<EOperation> rv = new ArrayList<EOperation>(r1.size() + r2.size());
            rv.addAll((Collection<EOperation>)r1);
            rv.addAll(r2);
            return rv;
        }
        return r2;
    }

    private List<ICompletionProposal> getAllCollectionOperations(String prefix) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String s = "select(e|expression-with-e)";
        if (s.startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "reject(e|expression-with-e)").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "collect(e|expression-with-e)").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "exists(e|expression-with-e)").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "notExists(e|expression-with-e)").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "forAll(e|expression-with-e)").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "[EClassifier]").startsWith(prefix)) {
            result.add(this.proposalFactory.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("EClassifier"), "EClassifier".length()));
        }
        return result;
    }

    public static class ExpressionSimpleAnalyzer {
        private final Set<Integer> operators = new HashSet<Integer>();
        private final Set<Integer> stopper;
        private final Set<Integer> methodNames;
        private final Set<Integer> operands;
        private final Map<Integer, Integer> blockTokens;

        public ExpressionSimpleAnalyzer() {
            this.operators.add(28);
            this.operators.add(26);
            this.operators.add(91);
            this.operators.add(5);
            this.operators.add(18);
            this.operators.add(16);
            this.operators.add(19);
            this.operators.add(17);
            this.operators.add(15);
            this.operators.add(4);
            this.operators.add(20);
            this.operators.add(54);
            this.operators.add(29);
            this.operators.add(32);
            this.operators.add(90);
            this.stopper = new HashSet<Integer>();
            this.stopper.add(1);
            this.stopper.add(79);
            this.stopper.add(95);
            this.stopper.add(73);
            this.stopper.add(74);
            this.stopper.add(71);
            this.methodNames = new HashSet<Integer>();
            this.methodNames.add(3);
            this.methodNames.add(45);
            this.methodNames.add(41);
            this.methodNames.add(40);
            this.methodNames.add(47);
            this.methodNames.add(46);
            this.methodNames.add(50);
            this.methodNames.add(43);
            this.methodNames.add(44);
            this.methodNames.add(48);
            this.methodNames.add(49);
            this.methodNames.add(42);
            this.methodNames.add(39);
            this.methodNames.add(57);
            this.methodNames.add(58);
            this.methodNames.add(59);
            this.methodNames.add(60);
            this.methodNames.add(61);
            this.methodNames.add(62);
            this.methodNames.add(63);
            this.methodNames.add(51);
            this.operands = new HashSet<Integer>();
            this.operands.add(3);
            this.operands.add(45);
            this.operands.add(41);
            this.operands.add(56);
            this.operands.add(40);
            this.operands.add(31);
            this.operands.add(47);
            this.operands.add(46);
            this.operands.add(55);
            this.operands.add(33);
            this.operands.add(52);
            this.operands.add(53);
            this.operands.add(27);
            this.blockTokens = new HashMap<Integer, Integer>();
            this.blockTokens.put(1, 2);
            this.blockTokens.put(74, 78);
        }

        public String[] computePrefixAndTargetExpression(String str) {
            ReverseScanner scanner = new ReverseScanner(str);
            String prefix = "";
            IToken t = scanner.previousToken();
            if (t != null) {
                if (!Character.isWhitespace(str.charAt(str.length() - 1)) && Character.isJavaIdentifierStart(t.toString().charAt(0))) {
                    prefix = t.toString();
                    t = scanner.previousToken();
                }
                int exprEnd = scanner.getOffset();
                if (t != null && (t.getKind() == 91 || t.getKind() == 90)) {
                    boolean lastWasOperator = true;
                    boolean stop = false;
                    while (!stop && (t = scanner.previousToken()) != null) {
                        if (this.isOperand(t)) {
                            if (lastWasOperator) {
                                lastWasOperator = false;
                                continue;
                            }
                            scanner.nextToken();
                            stop = true;
                            continue;
                        }
                        if (t.getKind() == 91 || t.getKind() == 90) {
                            if (!lastWasOperator) {
                                lastWasOperator = true;
                                continue;
                            }
                            String[] stringArray = new String[2];
                            stringArray[0] = prefix;
                            return stringArray;
                        }
                        if (this.isBlockCloser(t) && lastWasOperator) {
                            IToken temp;
                            lastWasOperator = false;
                            Stack<IToken> s = new Stack<IToken>();
                            s.push(t);
                            while (!s.isEmpty()) {
                                temp = scanner.previousToken();
                                if (temp == null) {
                                    String[] stringArray = new String[2];
                                    stringArray[0] = prefix;
                                    return stringArray;
                                }
                                if (temp.getKind() == t.getKind()) {
                                    s.push(temp);
                                    continue;
                                }
                                if (!this.isOpposite(temp, t)) continue;
                                s.pop();
                            }
                            if (t.getKind() != 2 || this.isMethodName(temp = scanner.previousToken())) continue;
                            scanner.nextToken();
                            continue;
                        }
                        scanner.nextToken();
                        stop = true;
                    }
                    return new String[]{prefix, str.substring(scanner.getOffset(), exprEnd).trim()};
                }
            }
            String[] stringArray = new String[2];
            stringArray[0] = prefix;
            return stringArray;
        }

        private boolean isMethodName(IToken temp) {
            return this.methodNames.contains(temp.getKind());
        }

        private boolean isOpposite(IToken left, IToken right) {
            Integer temp = this.blockTokens.get(left.getKind());
            return temp != null && right.getKind() == temp.intValue();
        }

        private boolean isBlockCloser(IToken t) {
            return this.blockTokens.values().contains(t.getKind());
        }

        private boolean isOperand(IToken t) {
            return this.operands.contains(t.getKind());
        }
    }
}

