/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import junit.framework.TestCase;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContextImpl;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;

public class StatementAnalyzationTest
extends TestCase {
    private XpandExecutionContextImpl execCtx;

    protected void setUp() throws Exception {
        super.setUp();
        this.execCtx = new XpandExecutionContextImpl((ResourceManager)new TestsResourceManager(), (Output)new BufferOutput(new StringBuilder()), null);
    }

    public final void testAnalyzation() {
        AnalysationIssue[] issues = new XpandFacade((XpandExecutionContext)this.execCtx).analyze("org::eclipse::gmf::tests::xpand::evaluate::EvaluateStart");
        this.dumpIssues(issues);
        StatementAnalyzationTest.assertTrue((issues.length == 0 ? 1 : 0) != 0);
    }

    private void dumpIssues(AnalysationIssue[] issues) {
        int i = 0;
        while (i < issues.length) {
            AnalysationIssue issue = issues[i];
            String buffer = issue.getType() + " : " + issue.getMessage() + " on line " + (issue.getElement() != null ? Integer.valueOf(issue.getElement().getLine()) : "");
            System.out.println(buffer);
            ++i;
        }
    }
}

